/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.entity.Player;

@IocBean
public class ModeProvider {
    private final Map<String, GeneralModeConfiguration> modeConfigurations;
    private final PermissionHandler permissionHandler;

    public ModeProvider(Options options, PermissionHandler permissionHandler) {
        this.modeConfigurations = options.modeConfigurations;
        this.permissionHandler = permissionHandler;
    }

    public Optional<GeneralModeConfiguration> getConfiguration(String modeName) {
        return Optional.ofNullable(this.modeConfigurations.get(modeName));
    }

    public GeneralModeConfiguration getMode(SppPlayer player, String modeName) {
        return this.getMode(player.getPlayer(), modeName);
    }

    public GeneralModeConfiguration getMode(Player player, String modeName) {
        if (!this.modeConfigurations.containsKey(modeName)) {
            throw new BusinessException("&CCan't turn on staff mode. Mode [" + modeName + "] does not exist");
        }
        GeneralModeConfiguration modeConfiguration = this.modeConfigurations.get(modeName);
        if (!modeConfiguration.isModeValidInWorld(player.getWorld())) {
            throw new BusinessException("&CMode can not be actived in this world");
        }
        if (!this.permissionHandler.has(player, modeConfiguration.getPermission())) {
            throw new BusinessException("&CYou don't have permission to access this mode");
        }
        return modeConfiguration;
    }

    public Optional<GeneralModeConfiguration> findMode(Player player, String modeName) {
        return this.modeConfigurations.values().stream().filter(m -> m.getName().equals(modeName)).filter(g -> this.permissionHandler.has(player, g.getPermission())).filter(g -> g.isModeValidInWorld(player.getWorld())).findFirst();
    }

    public Optional<GeneralModeConfiguration> calculateMode(Player player) {
        return this.modeConfigurations.values().stream().sorted(Comparator.comparingInt(GeneralModeConfiguration::getWeight).reversed()).filter(g -> this.permissionHandler.has(player, g.getPermission())).filter(g -> g.isModeValidInWorld(player.getWorld())).findFirst();
    }
}

