/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode;

import java.util.Optional;
import net.shortninja.staffplus.core.application.session.OnlinePlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.StaffPlusPlusJoinedEvent;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.mode.StaffModeService;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

@IocBukkitListener
public class ModeJoinListener
implements Listener {
    @ConfigProperty(value="permissions:mode")
    private String permissionMode;
    private final StaffModeService staffModeService;
    private final PermissionHandler permission;
    private final BukkitUtils bukkitUtils;

    public ModeJoinListener(StaffModeService staffModeService, PermissionHandler permission, BukkitUtils bukkitUtils) {
        this.staffModeService = staffModeService;
        this.permission = permission;
        this.bukkitUtils = bukkitUtils;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onJoin(StaffPlusPlusJoinedEvent event) {
        Player player = event.getPlayer();
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> {
            Optional<GeneralModeConfiguration> modeConfiguration;
            OnlinePlayerSession session = event.getPlayerSession();
            Optional<GeneralModeConfiguration> defaultMode = this.staffModeService.getModeConfig(player);
            Optional<GeneralModeConfiguration> optional = modeConfiguration = session.getModeConfig().isPresent() ? session.getModeConfig() : defaultMode;
            if (modeConfiguration.isPresent() && this.permission.has(player, this.permissionMode) && (session.isInStaffMode() || modeConfiguration.get().isModeEnableOnLogin())) {
                this.staffModeService.turnStaffModeOn(player, modeConfiguration.get());
            } else {
                this.staffModeService.turnStaffModeOff(player);
            }
        });
    }
}

