/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.domain.staff.mode.ModeData;
import net.shortninja.staffplus.core.domain.staff.mode.ModeDataSerializer;
import org.bukkit.entity.Player;

@IocBean
public class ModeDataRepository {
    private static final Map<UUID, ModeData> cache = new HashMap<UUID, ModeData>();
    private final ModeDataSerializer modeDataSerializer = new ModeDataSerializer();

    public Optional<ModeData> retrieveModeData(UUID uuid) {
        if (cache.containsKey(uuid)) {
            return Optional.ofNullable(cache.get(uuid));
        }
        Optional<ModeData> retrievedModeData = this.modeDataSerializer.retrieve(uuid);
        retrievedModeData.ifPresent(m -> cache.put(m.getUuid(), (ModeData)m));
        return retrievedModeData;
    }

    public void saveModeData(ModeData modeData) {
        if (cache.containsKey(modeData.getUuid())) {
            cache.put(modeData.getUuid(), modeData);
        }
        this.modeDataSerializer.save(modeData);
    }

    public void deleteModeData(Player player) {
        cache.remove(player.getUniqueId());
        this.modeDataSerializer.delete(player.getUniqueId().toString());
    }
}

