/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode;

import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import org.bukkit.GameRule;
import org.bukkit.advancement.Advancement;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@IocBukkitListener
public class ModeAdvancementListener
implements Listener {
    private final OnlineSessionsManager sessionManager;
    private boolean announceGameruleDisabledByUs = false;

    public ModeAdvancementListener(OnlineSessionsManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onAdvancementCompleted(PlayerAdvancementDoneEvent event) {
        final Player player = event.getPlayer();
        PlayerSession session = this.sessionManager.get(player);
        if (!session.isInStaffMode()) {
            return;
        }
        if (!((Boolean)player.getWorld().getGameRuleValue(GameRule.ANNOUNCE_ADVANCEMENTS)).booleanValue() && !this.announceGameruleDisabledByUs) {
            return;
        }
        Advancement advancement = event.getAdvancement();
        this.announceGameruleDisabledByUs = true;
        player.getWorld().setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
        for (String criteria : advancement.getCriteria()) {
            player.getAdvancementProgress(advancement).revokeCriteria(criteria);
        }
        new BukkitRunnable(){

            public void run() {
                player.getWorld().setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)true);
                ModeAdvancementListener.this.announceGameruleDisabledByUs = false;
            }
        }.runTask((Plugin)StaffPlusPlus.get());
    }
}

