/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.location.gui.cmd;

import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionService;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:staff-locations.create", permissions={"permissions:staff-locations.create"}, description="Create a staff location.", usage="[name]")
@IocBean(conditionalOnProperty="staff-locations-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class CreateStaffLocationCmd
extends AbstractCmd {
    private final GuiActionService guiActionService;

    public CreateStaffLocationCmd(Messages messages, PermissionHandler permissionHandler, CommandService commandService, GuiActionService guiActionService) {
        super(messages, permissionHandler, commandService);
        this.guiActionService = guiActionService;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        Player initiator = this.validateIsPlayer(sender);
        String locationName = JavaUtils.compileWords(args, 0);
        this.guiActionService.executeAction(initiator, GuiActionBuilder.fromAction("staff-locations/create-flow/select-icon").param("locationName", locationName).build());
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 1;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.empty();
    }
}

