/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.location.gui;

import java.util.HashMap;
import java.util.List;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionReturnType;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.location.StaffLocation;
import net.shortninja.staffplus.core.domain.staff.location.StaffLocationNote;
import net.shortninja.staffplus.core.domain.staff.location.StaffLocationService;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class StaffLocationsNotesGuiController {
    private static final int PAGE_SIZE = 45;
    private static final String CANCEL = "cancel";
    @ConfigProperty(value="%lang%:staff-locations.prefix")
    private String prefix;
    @ConfigProperty(value="permissions:staff-locations.view-notes")
    private String viewNotesPermission;
    @ConfigProperty(value="permissions:staff-locations.create-note")
    private String createNotePermission;
    @ConfigProperty(value="permissions:staff-locations.delete-note")
    private String deleteNotePermission;
    @ConfigProperty(value="%lang%:staff-locations.add-note-chat-info")
    private String addNoteChatInfoMessage;
    private final StaffLocationService staffLocationService;
    private final BukkitUtils bukkitUtils;
    private final PermissionHandler permissionHandler;
    private final Messages messages;
    private final OnlineSessionsManager sessionManager;

    public StaffLocationsNotesGuiController(StaffLocationService staffLocationService, BukkitUtils bukkitUtils, PermissionHandler permissionHandler, Messages messages, OnlineSessionsManager sessionManager) {
        this.staffLocationService = staffLocationService;
        this.bukkitUtils = bukkitUtils;
        this.permissionHandler = permissionHandler;
        this.messages = messages;
        this.sessionManager = sessionManager;
    }

    @GuiAction(value="staff-location-notes/view")
    public AsyncGui<GuiTemplate> getNotesOverview(Player player, @GuiParam(value="page", defaultValue="0") int page, @GuiParam(value="locationId") int locationId) {
        this.permissionHandler.validate((CommandSender)player, this.viewNotesPermission);
        return AsyncGui.async(() -> {
            StaffLocation staffLocation = this.staffLocationService.getStaffLocation(locationId);
            List<StaffLocationNote> notes = this.staffLocationService.getNotesForLocation(staffLocation, page * 45, 45);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("notes", notes);
            return GuiTemplate.template("gui/staff-locations/notes-overview.ftl", params);
        });
    }

    @GuiAction(value="staff-location-notes/create")
    public void createNote(Player player, @GuiParam(value="locationId") int locationId) {
        this.permissionHandler.validate((CommandSender)player, this.createNotePermission);
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> {
            StaffLocation staffLocation = this.staffLocationService.getStaffLocation(locationId);
            this.messages.send((CommandSender)player, this.addNoteChatInfoMessage, this.prefix);
            PlayerSession playerSession = this.sessionManager.get(player);
            playerSession.setChatAction((player1, message) -> {
                if (message.equalsIgnoreCase(CANCEL)) {
                    this.messages.send((CommandSender)player, "&CYou have cancelled your note", this.prefix);
                    return;
                }
                this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.staffLocationService.addNote(player, staffLocation, message));
            });
        });
    }

    @GuiAction(value="staff-location-notes/view/delete", skipHistory=true)
    public GuiTemplate showNoteDeletionConfirmation(Player player, @GuiParam(value="noteId") int noteId, @GuiParam(value="locationId") int locationId) {
        this.permissionHandler.validate((CommandSender)player, this.deleteNotePermission);
        String confirmAction = GuiActionBuilder.builder().action("staff-location-notes/delete").param("noteId", String.valueOf(noteId)).param("locationId", String.valueOf(locationId)).build();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("confirmationMessage", "&7Delete note(ID=" + noteId + ")");
        params.put("title", "Delete note?");
        params.put("confirmAction", confirmAction);
        params.put("cancelAction", "$BACK");
        return GuiTemplate.template("gui/commons/confirmation.ftl", params);
    }

    @GuiAction(value="staff-location-notes/delete")
    public AsyncGui<GuiActionReturnType> deleteNote(Player player, @GuiParam(value="noteId") int noteId, @GuiParam(value="locationId") int locationId) {
        this.permissionHandler.validate((CommandSender)player, this.deleteNotePermission);
        return AsyncGui.async(() -> {
            StaffLocation location = this.staffLocationService.getStaffLocation(locationId);
            this.staffLocationService.deleteNote(player, location, noteId);
            return GuiActionReturnType.BACK;
        });
    }
}

