/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.location.gui;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigObjectList;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionReturnType;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionService;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParams;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.location.StaffLocation;
import net.shortninja.staffplus.core.domain.staff.location.StaffLocationRepository;
import net.shortninja.staffplus.core.domain.staff.location.StaffLocationService;
import net.shortninja.staffplus.core.domain.staff.location.config.StaffLocationIconConfig;
import net.shortninja.staffplus.core.domain.staff.location.gui.StaffLocationFiltersMapper;
import net.shortninja.staffplusplus.stafflocations.StaffLocationFilters;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@GuiController
public class StaffLocationsGuiController {
    private static final int PAGE_SIZE = 45;
    private static final String CANCEL = "cancel";
    @ConfigProperty(value="%lang%:staff-locations.prefix")
    private String prefix;
    @ConfigProperty(value="permissions:staff-locations.create")
    private String createPermission;
    @ConfigProperty(value="permissions:staff-locations.edit")
    private String editPermission;
    @ConfigProperty(value="permissions:staff-locations.delete")
    private String deletePermission;
    @ConfigProperty(value="permissions:staff-locations.teleport")
    private String teleportPermission;
    @ConfigProperty(value="%lang%:staff-locations.add-chat-info")
    private String addChatInfoMessage;
    @ConfigProperty(value="%lang%:gui_stafflocations_delete-confirmation-title")
    private String deleteConfirmationTitle;
    @ConfigProperty(value="%lang%:gui_stafflocations_delete-confirmation-message")
    private String deleteConfirmationMessage;
    @ConfigProperty(value="staff-locations-module.icons")
    @ConfigObjectList(value=StaffLocationIconConfig.class)
    private List<StaffLocationIconConfig> predefinedIcons;
    private final StaffLocationRepository staffLocationRepository;
    private final StaffLocationService staffLocationService;
    private final BukkitUtils bukkitUtils;
    private final PermissionHandler permissionHandler;
    private final Messages messages;
    private final OnlineSessionsManager sessionManager;
    private final StaffLocationFiltersMapper staffLocationFiltersMapper;
    private final GuiActionService guiActionService;

    public StaffLocationsGuiController(StaffLocationRepository staffLocationRepository, StaffLocationService staffLocationService, BukkitUtils bukkitUtils, PermissionHandler permissionHandler, Messages messages, OnlineSessionsManager sessionManager, StaffLocationFiltersMapper staffLocationFiltersMapper, GuiActionService guiActionService) {
        this.staffLocationRepository = staffLocationRepository;
        this.staffLocationService = staffLocationService;
        this.bukkitUtils = bukkitUtils;
        this.permissionHandler = permissionHandler;
        this.messages = messages;
        this.sessionManager = sessionManager;
        this.staffLocationFiltersMapper = staffLocationFiltersMapper;
        this.guiActionService = guiActionService;
    }

    @GuiAction(value="staff-locations/view")
    public AsyncGui<GuiTemplate> staffLocationsOverview(@GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            List<StaffLocation> locations = this.staffLocationRepository.getStaffLocations(page * 45, 45);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("locations", locations);
            return GuiTemplate.template("gui/staff-locations/overview.ftl", params);
        });
    }

    @GuiAction(value="staff-locations/view/detail")
    public AsyncGui<GuiTemplate> staffLocationDetailView(@GuiParam(value="locationId") int locationId) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("location", this.staffLocationService.getStaffLocation(locationId));
            return GuiTemplate.template("gui/staff-locations/staff-location-detail.ftl", params);
        });
    }

    @GuiAction(value="staff-locations/view/options")
    public AsyncGui<GuiTemplate> staffLocationsOptions(Player player, @GuiParam(value="locationId") int locationId) {
        return AsyncGui.async(() -> {
            StaffLocation location = this.staffLocationService.getStaffLocation(locationId);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("location", location);
            return GuiTemplate.template("gui/staff-locations/options.ftl", params);
        });
    }

    @GuiAction(value="staff-locations/view/find-locations")
    public AsyncGui<GuiTemplate> viewFindLocations(@GuiParam(value="page", defaultValue="0") int page, @GuiParams Map<String, String> allParams) {
        return AsyncGui.async(() -> {
            StaffLocationFilters.StaffLocationFiltersBuilder filtersBuilder = new StaffLocationFilters.StaffLocationFiltersBuilder();
            allParams.forEach((k, v) -> this.staffLocationFiltersMapper.map((String)k, (String)v, filtersBuilder));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("locations", this.staffLocationService.findLocations(filtersBuilder.build(), page * 45, 45));
            return GuiTemplate.template("gui/staff-locations/overview.ftl", params);
        });
    }

    @GuiAction(value="staff-locations/create-flow/select-name")
    public void createFlowSelectName(Player player) {
        this.permissionHandler.validate((CommandSender)player, this.createPermission);
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> {
            this.messages.send((CommandSender)player, this.addChatInfoMessage, this.prefix);
            PlayerSession playerSession = this.sessionManager.get(player);
            playerSession.setChatAction((player1, message) -> {
                if (message.equalsIgnoreCase(CANCEL)) {
                    this.messages.send((CommandSender)player, "&CYou have cancelled saving this location", this.prefix);
                    return;
                }
                this.guiActionService.executeAction(player, GuiActionBuilder.fromAction("staff-locations/create-flow/select-icon").param("locationName", message).build());
            });
        });
    }

    @GuiAction(value="staff-locations/create-flow/select-icon")
    public GuiTemplate createFlowIconSelectIcon(@GuiParam(value="locationName") String locationName, @GuiParam(value="page", defaultValue="0") int page) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("locationName", locationName);
        params.put("icons", JavaUtils.getPageOfList(this.getStaffLocationIcons(), page, 45));
        return GuiTemplate.template("gui/staff-locations/select-icon-create.ftl", params);
    }

    @GuiAction(value="staff-locations/create-flow/save")
    public void createLocation(Player player, @GuiParam(value="locationName") String locationName, @GuiParam(value="locationIcon") String locationIcon) {
        this.permissionHandler.validate((CommandSender)player, this.createPermission);
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.staffLocationService.saveLocation(player, locationName, Material.valueOf((String)locationIcon)));
    }

    @GuiAction(value="staff-locations/edit-flow/select-icon", skipHistory=true)
    public GuiTemplate editFlowIconSelectIcon(@GuiParam(value="locationId") int locationId, @GuiParam(value="page", defaultValue="0") int page) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("locationId", locationId);
        params.put("icons", JavaUtils.getPageOfList(this.getStaffLocationIcons(), page, 45));
        return GuiTemplate.template("gui/staff-locations/select-icon-edit.ftl", params);
    }

    @GuiAction(value="staff-locations/edit/name", skipHistory=true)
    public void editStaffLocationName(Player player, @GuiParam(value="locationId") int locationId) {
        this.permissionHandler.validate((CommandSender)player, this.editPermission);
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> {
            this.messages.send((CommandSender)player, this.addChatInfoMessage, this.prefix);
            PlayerSession playerSession = this.sessionManager.get(player);
            playerSession.setChatAction((player1, message) -> {
                if (message.equalsIgnoreCase(CANCEL)) {
                    this.messages.send((CommandSender)player, "&CYou have cancelled saving this location", this.prefix);
                    return;
                }
                this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.staffLocationService.updateName(player, locationId, message));
            });
        });
    }

    @GuiAction(value="staff-locations/edit/icon", skipHistory=true)
    public AsyncGui<GuiActionReturnType> editIcon(Player player, @GuiParam(value="locationId") int locationId, @GuiParam(value="locationIcon") String locationIcon) {
        this.permissionHandler.validate((CommandSender)player, this.editPermission);
        return AsyncGui.async(() -> {
            this.staffLocationService.updateIcon(player, locationId, Material.valueOf((String)locationIcon));
            return GuiActionReturnType.BACK;
        });
    }

    @GuiAction(value="staff-locations/edit/location", skipHistory=true)
    public AsyncGui<GuiActionReturnType> editLocation(Player player, @GuiParam(value="locationId") int locationId) {
        this.permissionHandler.validate((CommandSender)player, this.editPermission);
        return AsyncGui.async(() -> {
            this.staffLocationService.updateLocation(player, locationId);
            return GuiActionReturnType.BACK;
        });
    }

    @GuiAction(value="staff-locations/teleport")
    public void teleport(Player player, @GuiParam(value="locationId") int locationId) {
        this.permissionHandler.validate((CommandSender)player, this.teleportPermission);
        this.staffLocationService.goToLocation(player, locationId);
    }

    @GuiAction(value="staff-locations/view/delete-confirmation", skipHistory=true)
    public GuiTemplate showLocationDeletionConfirmation(Player player, @GuiParam(value="locationId") int locationId, @GuiParam(value="locationName") String locationName) {
        this.permissionHandler.validate((CommandSender)player, this.deletePermission);
        String confirmAction = GuiActionBuilder.builder().action("staff-locations/delete").param("locationId", String.valueOf(locationId)).build();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("confirmationMessage", this.deleteConfirmationMessage.replace("%name%", locationName));
        params.put("title", this.deleteConfirmationTitle.replace("%name%", locationName));
        params.put("confirmAction", confirmAction);
        params.put("cancelAction", "$BACK");
        return GuiTemplate.template("gui/commons/confirmation.ftl", params);
    }

    @GuiAction(value="staff-locations/delete")
    public AsyncGui<GuiActionReturnType> delete(Player player, @GuiParam(value="locationId") int locationId) {
        this.permissionHandler.validate((CommandSender)player, this.deletePermission);
        return AsyncGui.async(() -> {
            this.staffLocationService.deleteLocation(player, locationId);
            return GuiActionReturnType.CLOSE;
        });
    }

    @NotNull
    private List<StaffLocationIconConfig> getStaffLocationIcons() {
        return this.predefinedIcons.isEmpty() ? Arrays.stream(Material.values()).filter(this::isNotAir).map(m -> new StaffLocationIconConfig(m.name(), "")).collect(Collectors.toList()) : this.predefinedIcons;
    }

    private boolean isNotAir(Material m) {
        return m != Material.AIR && m != Material.CAVE_AIR && m != Material.LEGACY_AIR && m != Material.VOID_AIR;
    }
}

