/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.location.gui;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplusplus.session.SppInteractor;
import net.shortninja.staffplusplus.stafflocations.StaffLocationCreatedEvent;
import net.shortninja.staffplusplus.stafflocations.StaffLocationDeletedEvent;
import net.shortninja.staffplusplus.stafflocations.StaffLocationIconChangedEvent;
import net.shortninja.staffplusplus.stafflocations.StaffLocationLocationChangedEvent;
import net.shortninja.staffplusplus.stafflocations.StaffLocationNameChangedEvent;
import net.shortninja.staffplusplus.stafflocations.StaffLocationNoteCreatedEvent;
import net.shortninja.staffplusplus.stafflocations.StaffLocationNoteDeletedEvent;
import net.shortninja.staffplusplus.stafflocations.StaffLocationTeleportedEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class StaffLocationsChatNotifier
implements Listener {
    private final PlayerManager playerManager;
    private final Messages messages;
    @ConfigProperty(value="%lang%:staff-locations.prefix")
    private String prefix;
    @ConfigProperty(value="%lang%:staff-locations.created")
    private String createdMessage;
    @ConfigProperty(value="%lang%:staff-locations.updated")
    private String updatedMessage;
    @ConfigProperty(value="%lang%:staff-locations.deleted")
    private String deletedMessage;
    @ConfigProperty(value="%lang%:staff-locations.teleported")
    private String teleportedMessage;
    @ConfigProperty(value="%lang%:staff-locations.note-created")
    private String noteCreatedMessage;
    @ConfigProperty(value="%lang%:staff-locations.note-deleted")
    private String noteDeletedMessage;

    public StaffLocationsChatNotifier(PlayerManager playerManager, Messages messages) {
        this.playerManager = playerManager;
        this.messages = messages;
    }

    @EventHandler
    public void staffLocationCreated(StaffLocationCreatedEvent event) {
        this.playerManager.getOnlinePlayer(event.getStaffLocation().getCreatorUuid()).ifPresent(p -> this.messages.send((SppInteractor)p, this.createdMessage, this.prefix));
    }

    @EventHandler
    public void staffLocationNameChanged(StaffLocationNameChangedEvent event) {
        this.messages.send((CommandSender)event.getEditedBy(), this.updatedMessage, this.prefix);
    }

    @EventHandler
    public void staffLocationIconChanged(StaffLocationIconChangedEvent event) {
        this.messages.send((CommandSender)event.getEditedBy(), this.updatedMessage, this.prefix);
    }

    @EventHandler
    public void staffLocationLocationChanged(StaffLocationLocationChangedEvent event) {
        this.messages.send((CommandSender)event.getEditedBy(), this.updatedMessage, this.prefix);
    }

    @EventHandler
    public void staffLocationDeleted(StaffLocationDeletedEvent event) {
        this.messages.send((CommandSender)event.getDeletedByPlayer(), this.deletedMessage, this.prefix);
    }

    @EventHandler
    public void staffLocationTeleported(StaffLocationTeleportedEvent event) {
        this.messages.send((CommandSender)event.getTeleportedPlayer(), this.teleportedMessage.replace("%name%", event.getStaffLocation().getName()), this.prefix);
    }

    @EventHandler
    public void staffLocationNoteCreated(StaffLocationNoteCreatedEvent event) {
        this.playerManager.getOnlinePlayer(event.getStaffLocationNote().getNotedByUuid()).ifPresent(p -> this.messages.send((SppInteractor)p, this.noteCreatedMessage, this.prefix));
    }

    @EventHandler
    public void staffLocationNoteDeleted(StaffLocationNoteDeletedEvent event) {
        this.messages.send((CommandSender)event.getDeletedBy(), this.noteDeletedMessage, this.prefix);
    }
}

