/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.location;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.UUID;
import net.shortninja.staffplusplus.stafflocations.IStaffLocationNote;
import org.bukkit.entity.Player;

public class StaffLocationNote
implements IStaffLocationNote {
    private int id;
    private final int locationId;
    private final String note;
    private final UUID notedByUuid;
    private final String notedByName;
    private final long timestamp;

    public StaffLocationNote(int locationId, String note, Player notedBy) {
        this.locationId = locationId;
        this.note = note;
        this.notedByUuid = notedBy.getUniqueId();
        this.notedByName = notedBy.getName();
        this.timestamp = System.currentTimeMillis();
    }

    public StaffLocationNote(int id, int locationId, String note, UUID notedByUuid, String notedByName, long timestamp) {
        this.id = id;
        this.locationId = locationId;
        this.note = note;
        this.notedByUuid = notedByUuid;
        this.notedByName = notedByName;
        this.timestamp = timestamp;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int getLocationId() {
        return this.locationId;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public UUID getNotedByUuid() {
        return this.notedByUuid;
    }

    @Override
    public Long getCreationTimestamp() {
        return this.timestamp;
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.timestamp), ZoneId.systemDefault());
    }

    @Override
    public String getNotedByName() {
        return this.notedByName;
    }
}

