/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.kick.gui;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.IProtocolService;
import net.shortninja.staffplus.core.common.Items;
import net.shortninja.staffplus.core.common.gui.LoreBuilder;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionType;
import net.shortninja.staffplus.core.domain.staff.infractions.config.InfractionsConfiguration;
import net.shortninja.staffplus.core.domain.staff.infractions.gui.views.InfractionGuiProvider;
import net.shortninja.staffplus.core.domain.staff.kick.Kick;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

@IocBean
@IocMultiProvider(value={InfractionGuiProvider.class})
public class KickedPlayerItemBuilder
implements InfractionGuiProvider<Kick> {
    private final IProtocolService protocolService;
    private final Options options;
    private final InfractionsConfiguration infractionsConfiguration;

    public KickedPlayerItemBuilder(IProtocolService protocolService, Options options, InfractionsConfiguration infractionsConfiguration) {
        this.protocolService = protocolService;
        this.options = options;
        this.infractionsConfiguration = infractionsConfiguration;
    }

    public ItemStack build(Kick kick) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(kick.getCreationDate().toInstant(), ZoneOffset.UTC);
        String time = localDateTime.truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ofPattern(this.options.timestampFormat));
        List<String> lore = LoreBuilder.builder("&b", "&6").addItem("Id", String.valueOf(kick.getId())).addItem("Server", kick.getServerName(), this.options.serverSyncConfiguration.kickSyncServers.isEnabled()).addItem("Kicked player", kick.getTargetName()).addItem("Issuer", kick.getIssuerName()).addItem("Issued on", time).addIndented("Reason", kick.getReason()).build();
        ItemStack item = Items.builder().setMaterial(Material.PLAYER_HEAD).setName("&6Kick").addLore(lore).build();
        return this.protocolService.getVersionProtocol().addNbtString(item, String.valueOf(kick.getId()));
    }

    @Override
    public InfractionType getType() {
        return InfractionType.KICK;
    }

    @Override
    public ItemStack getMenuItem(Kick kick) {
        ItemStack itemStack = this.build(kick);
        itemStack.setType(this.infractionsConfiguration.getKicksGuiItem());
        return itemStack;
    }
}

