/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.kick.gui;

import java.util.HashMap;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.common.exceptions.PlayerOfflineException;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.kick.KickService;
import net.shortninja.staffplus.core.domain.staff.kick.config.KickConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class KickGuiController {
    private static final int PAGE_SIZE = 45;
    private final KickService kickService;
    private final PlayerManager playerManager;
    private final KickConfiguration kickConfiguration;

    public KickGuiController(KickService kickService, PlayerManager playerManager, KickConfiguration kickConfiguration) {
        this.kickService = kickService;
        this.playerManager = playerManager;
        this.kickConfiguration = kickConfiguration;
    }

    @GuiAction(value="manage-kicks/view/kick/reason-select")
    public GuiTemplate getKickReasonSelect(@GuiParam(value="targetPlayerName") String targetPlayerName) {
        SppPlayer target = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("target", target);
        params.put("reasons", this.kickConfiguration.kickReasons);
        return GuiTemplate.template("gui/kicks/kick-reason-selection.ftl", params);
    }

    @GuiAction(value="manage-kicks/view/overview")
    public AsyncGui<GuiTemplate> getKickOverview(@GuiParam(value="targetPlayerName") String targetPlayerName, @GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            SppPlayer target = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("kicks", this.kickService.getAllKicksForPlayer(target.getId(), page * 45, 45));
            return GuiTemplate.template("gui/kicks/kick-overview.ftl", params);
        });
    }

    @GuiAction(value="manage-kicks/kick")
    public void kick(Player player, @GuiParam(value="targetPlayerName") String targetPlayerName, @GuiParam(value="reason") String reason) {
        SppPlayer target = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        if (!target.isOnline()) {
            throw new PlayerOfflineException();
        }
        this.kickService.kick((CommandSender)player, target, reason);
    }
}

