/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.kick;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.infractions.Infraction;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionInfo;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionProvider;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionType;
import net.shortninja.staffplus.core.domain.staff.infractions.config.InfractionsConfiguration;
import net.shortninja.staffplus.core.domain.staff.kick.Kick;
import net.shortninja.staffplus.core.domain.staff.kick.config.KickConfiguration;
import net.shortninja.staffplus.core.domain.staff.kick.database.KicksRepository;
import net.shortninja.staffplusplus.kick.KickEvent;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@IocBean
@IocMultiProvider(value={InfractionProvider.class})
public class KickService
implements InfractionProvider {
    private final PermissionHandler permission;
    private final KicksRepository kicksRepository;
    private final KickConfiguration kickConfiguration;
    private final InfractionsConfiguration infractionsConfiguration;

    public KickService(PermissionHandler permission, KicksRepository kicksRepository, KickConfiguration kickConfiguration, InfractionsConfiguration infractionsConfiguration) {
        this.permission = permission;
        this.kicksRepository = kicksRepository;
        this.kickConfiguration = kickConfiguration;
        this.infractionsConfiguration = infractionsConfiguration;
    }

    public void kick(CommandSender issuer, SppPlayer playerToKick, String reason) {
        if (playerToKick.isOnline() && this.permission.has(playerToKick.getPlayer(), this.kickConfiguration.permissionKickByPass)) {
            throw new BusinessException("&CThis player bypasses being kicked");
        }
        if (!playerToKick.isOnline()) {
            throw new BusinessException("&CCannot kick offline player");
        }
        String issuerName = issuer instanceof Player ? issuer.getName() : "Console";
        UUID issuerUuid = issuer instanceof Player ? ((Player)issuer).getUniqueId() : Constants.CONSOLE_UUID;
        Kick kick = new Kick(reason, issuerName, issuerUuid, playerToKick.getUsername(), playerToKick.getId());
        kick.setId(this.kicksRepository.addKick(kick));
        BukkitUtils.sendEvent(new KickEvent(kick));
    }

    public List<Kick> getAllKicksForPlayer(UUID playerKicked, int offset, int amount) {
        return this.kicksRepository.getKicksForPlayer(playerKicked, offset, amount);
    }

    @Override
    public List<? extends Infraction> getInfractions(Player executor, UUID playerUUID) {
        if (!this.infractionsConfiguration.isShowKicks()) {
            return Collections.emptyList();
        }
        return this.kicksRepository.getKicksForPlayer(playerUUID);
    }

    @Override
    public Optional<InfractionInfo> getInfractionsInfo() {
        if (!this.infractionsConfiguration.isShowKicks()) {
            return Optional.empty();
        }
        return Optional.of(new InfractionInfo(InfractionType.KICK, this.kicksRepository.getCountByPlayer()));
    }

    @Override
    public InfractionType getType() {
        return InfractionType.KICK;
    }
}

