/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.kick;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.UUID;
import net.shortninja.staffplus.core.domain.staff.infractions.Infraction;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionType;
import net.shortninja.staffplusplus.kick.IKick;

public class Kick
implements IKick,
Infraction {
    private int id;
    private String reason;
    private Long creationDate;
    private String targetName;
    private UUID targetUuid;
    private String issuerName;
    private UUID issuerUuid;
    private String serverName;

    public Kick(int id, String reason, Long creationDate, String targetName, UUID targetUuid, String issuerName, UUID issuerUuid, String serverName) {
        this.id = id;
        this.reason = reason;
        this.creationDate = creationDate;
        this.targetName = targetName;
        this.targetUuid = targetUuid;
        this.issuerName = issuerName;
        this.issuerUuid = issuerUuid;
        this.serverName = serverName;
    }

    public Kick(String reason, String issuerName, UUID issuerUuid, String targetName, UUID targetUuid) {
        this.reason = reason;
        this.targetName = targetName;
        this.issuerName = issuerName;
        this.creationDate = System.currentTimeMillis();
        this.targetUuid = targetUuid;
        this.issuerUuid = issuerUuid;
    }

    @Override
    public Long getCreationTimestamp() {
        return this.creationDate;
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.creationDate), ZoneId.systemDefault());
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public UUID getTargetUuid() {
        return this.targetUuid;
    }

    @Override
    public UUID getIssuerUuid() {
        return this.issuerUuid;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public String getIssuerName() {
        return this.issuerName;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public InfractionType getInfractionType() {
        return InfractionType.KICK;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }
}

