/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.joinmessages;

import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.staff.joinmessages.JoinMessageGroup;
import net.shortninja.staffplus.core.domain.staff.joinmessages.JoinMessagesConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

@IocBukkitListener(conditionalOnProperty="joinmessages-module.enabled=true")
public class JoinMessageListener
implements Listener {
    private final JoinMessagesConfiguration joinMessagesConfiguration;
    private final Messages messages;

    public JoinMessageListener(JoinMessagesConfiguration joinMessagesConfiguration, Messages messages) {
        this.joinMessagesConfiguration = joinMessagesConfiguration;
        this.messages = messages;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        Optional<JoinMessageGroup> joinMessageGroup = this.joinMessagesConfiguration.getJoinMessageGroup(playerJoinEvent.getPlayer());
        joinMessageGroup.ifPresent(messageGroup -> {
            String joinMessage = this.messages.parse(playerJoinEvent.getPlayer(), messageGroup.getMessage().replace("%player%", playerJoinEvent.getPlayer().getName()));
            playerJoinEvent.setJoinMessage(joinMessage);
        });
    }
}

