/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate.gui.views;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.IProtocolService;
import net.shortninja.staffplus.core.common.Items;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.domain.staff.investigate.EvidenceEntity;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

@IocBean
public class InvestigationEvidenceItemBuilder {
    private final IProtocolService protocolService;
    private final Options options;

    public InvestigationEvidenceItemBuilder(IProtocolService protocolService, Options options) {
        this.protocolService = protocolService;
        this.options = options;
    }

    public ItemStack build(EvidenceEntity evidence) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(evidence.getCreationDate().toInstant(), ZoneOffset.UTC);
        String time = localDateTime.truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ofPattern(this.options.timestampFormat));
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("&bId: " + evidence.getId());
        lore.add("&bType: " + evidence.getEvidenceType() + " (ID=" + evidence.getEvidenceId() + ")");
        lore.add("&bLinked by: " + evidence.getLinkedByName());
        lore.add("&bLinked on: " + time);
        lore.add("&bDescription:");
        for (String line : JavaUtils.formatLines(evidence.getDescription(), 30)) {
            lore.add("  &b" + line);
        }
        lore.add("");
        lore.add("&CRight click to unlink evidence");
        ItemStack item = Items.builder().setMaterial(Material.PAPER).setName("&c" + evidence.getEvidenceType()).addLore(lore).build();
        return this.protocolService.getVersionProtocol().addNbtString(item, evidence.getId() + ";" + evidence.getEvidenceType() + ";" + evidence.getEvidenceId());
    }
}

