/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate.gui.views;

import java.util.List;
import java.util.function.Function;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMulti;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGui;
import net.shortninja.staffplus.core.common.gui.PagedGuiBuilder;
import net.shortninja.staffplus.core.domain.staff.investigate.EvidenceEntity;
import net.shortninja.staffplus.core.domain.staff.investigate.Investigation;
import net.shortninja.staffplus.core.domain.staff.investigate.InvestigationEvidenceService;
import net.shortninja.staffplus.core.domain.staff.investigate.gui.views.InvestigationEvidenceItemBuilder;
import net.shortninja.staffplusplus.investigate.evidence.EvidenceGuiClick;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@IocBean
public class EvidenceOverviewViewBuilder {
    private static final int PAGE_SIZE = 45;
    private final InvestigationEvidenceService investigationEvidenceService;
    private final InvestigationEvidenceItemBuilder investigationEvidenceItemBuilder;
    private final List<EvidenceGuiClick> evidenceGuiClicks;

    public EvidenceOverviewViewBuilder(InvestigationEvidenceService investigationEvidenceService, InvestigationEvidenceItemBuilder investigationEvidenceItemBuilder, @IocMulti(value=EvidenceGuiClick.class) List<EvidenceGuiClick> evidenceGuiClicks) {
        this.investigationEvidenceService = investigationEvidenceService;
        this.investigationEvidenceItemBuilder = investigationEvidenceItemBuilder;
        this.evidenceGuiClicks = evidenceGuiClicks;
    }

    public TubingGui buildGui(Player player, Investigation investigation, int page, String currentAction) {
        return new PagedGuiBuilder.Builder("Evidence").addPagedItems(currentAction, this.getItems(investigation, page * 45, 45), this.investigationEvidenceItemBuilder::build, this.getLeftAction(player), this.getDeleteAction(), page).backAction().build();
    }

    @NotNull
    private Function<EvidenceEntity, String> getLeftAction(Player player) {
        return evidence -> this.evidenceGuiClicks.stream().filter(e -> e.getType().equals(evidence.getEvidenceType())).findFirst().map(e -> e.getAction(player, evidence.getEvidenceId(), "$BACK")).orElse("$NOOP");
    }

    @NotNull
    private Function<EvidenceEntity, String> getDeleteAction() {
        return evidence -> GuiActionBuilder.builder().action("manage-investigation-evidence/view/unlink").param("evidenceId", String.valueOf(evidence.getId())).param("investigationId", String.valueOf(evidence.getInvestigationId())).build();
    }

    public List<EvidenceEntity> getItems(Investigation investigation, int offset, int amount) {
        return this.investigationEvidenceService.getEvidenceForInvestigation(investigation, offset, amount);
    }
}

