/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate.gui.notes;

import java.util.HashMap;
import java.util.List;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionReturnType;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.investigate.Investigation;
import net.shortninja.staffplus.core.domain.staff.investigate.InvestigationNoteEntity;
import net.shortninja.staffplus.core.domain.staff.investigate.InvestigationNoteService;
import net.shortninja.staffplus.core.domain.staff.investigate.InvestigationService;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class InvestigationNotesGuiController {
    private static final String CANCEL = "cancel";
    private static final int PAGE_SIZE = 45;
    private final InvestigationService investigationService;
    private final InvestigationNoteService investigationNoteService;
    private final Messages messages;
    private final OnlineSessionsManager sessionManager;
    private final BukkitUtils bukkitUtils;

    public InvestigationNotesGuiController(InvestigationService investigationService, InvestigationNoteService investigationNoteService, Messages messages, OnlineSessionsManager sessionManager, BukkitUtils bukkitUtils) {
        this.investigationService = investigationService;
        this.investigationNoteService = investigationNoteService;
        this.messages = messages;
        this.sessionManager = sessionManager;
        this.bukkitUtils = bukkitUtils;
    }

    @GuiAction(value="manage-investigation-notes/view")
    public AsyncGui<GuiTemplate> getNotesOverview(@GuiParam(value="page", defaultValue="0") int page, @GuiParam(value="investigationId") int investigationId) {
        return AsyncGui.async(() -> {
            Investigation investigation = this.investigationService.getInvestigation(investigationId);
            List<InvestigationNoteEntity> notes = this.investigationNoteService.getNotesForInvestigation(investigation, page * 45, 45);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("notes", notes);
            return GuiTemplate.template("gui/investigations/notes-overview.ftl", params);
        });
    }

    @GuiAction(value="manage-investigation-notes/view/delete")
    public GuiTemplate getDetail(@GuiParam(value="noteId") int noteId, @GuiParam(value="investigationId") int investigationId) {
        String confirmAction = GuiActionBuilder.builder().action("manage-investigation-notes/delete").param("noteId", String.valueOf(noteId)).param("investigationId", String.valueOf(investigationId)).build();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("confirmationMessage", "Are you sure you want to delete note(ID=" + noteId + ")");
        params.put("title", "Delete note?");
        params.put("confirmAction", confirmAction);
        params.put("cancelAction", "$BACK");
        return GuiTemplate.template("gui/commons/confirmation.ftl", params);
    }

    @GuiAction(value="manage-investigation-notes/delete")
    public AsyncGui<GuiActionReturnType> deleteNote(Player player, @GuiParam(value="noteId") int noteId, @GuiParam(value="investigationId") int investigationId) {
        return AsyncGui.async(() -> {
            Investigation investigation = this.investigationService.getInvestigation(investigationId);
            this.investigationNoteService.deleteNote(player, investigation, noteId);
            return GuiActionReturnType.BACK;
        });
    }

    @GuiAction(value="manage-investigation-notes/create")
    public void createNote(Player player, @GuiParam(value="investigationId") int investigationId) {
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> {
            Investigation investigation = this.investigationService.getInvestigation(investigationId);
            this.messages.send((CommandSender)player, "&1===================================================", this.messages.prefixInvestigations);
            this.messages.send((CommandSender)player, "&6Type your note in chat", this.messages.prefixInvestigations);
            this.messages.send((CommandSender)player, "&6      Type \"cancel\" to cancel adding a note ", this.messages.prefixInvestigations);
            this.messages.send((CommandSender)player, "&1===================================================", this.messages.prefixInvestigations);
            PlayerSession playerSession = this.sessionManager.get(player);
            playerSession.setChatAction((player1, message) -> {
                if (message.equalsIgnoreCase(CANCEL)) {
                    this.messages.send((CommandSender)player, "&CYou have cancelled your note", this.messages.prefixInvestigations);
                    return;
                }
                this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.investigationNoteService.addNote(player, investigation, message));
            });
        });
    }
}

