/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate.gui.investigation;

import java.util.HashMap;
import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.investigate.Investigation;
import net.shortninja.staffplus.core.domain.staff.investigate.InvestigationService;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class InvestigationGuiController {
    private static final int PAGE_SIZE = 45;
    private final PlayerManager playerManager;
    private final InvestigationService investigationService;
    private final BukkitUtils bukkitUtils;

    public InvestigationGuiController(PlayerManager playerManager, InvestigationService investigationService, BukkitUtils bukkitUtils) {
        this.playerManager = playerManager;
        this.investigationService = investigationService;
        this.bukkitUtils = bukkitUtils;
    }

    @GuiAction(value="manage-investigations/view/overview")
    public AsyncGui<GuiTemplate> getOverview(@GuiParam(value="page", defaultValue="0") int page, @GuiParam(value="targetPlayer") String targetPlayer) {
        return AsyncGui.async(() -> {
            SppPlayer target = null;
            if (StringUtils.isNotBlank(targetPlayer)) {
                target = this.playerManager.getOnOrOfflinePlayer(targetPlayer).orElseThrow(() -> new PlayerNotFoundException("Player not found for name: [" + targetPlayer + "]"));
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("investigations", this.getInvestigations(target, page * 45, 45));
            return GuiTemplate.template("gui/investigations/investigations-overview.ftl", params);
        });
    }

    @GuiAction(value="manage-investigations/view/show-resume-select")
    public AsyncGui<GuiTemplate> showSelectInvestigationToResume(Player player, @GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("investigations", this.investigationService.getPausedInvestigations(player, page * 45, 45));
            return GuiTemplate.template("gui/investigations/investigations-resume-select.ftl", params);
        });
    }

    private List<Investigation> getInvestigations(SppPlayer target, int offset, int amount) {
        if (target == null) {
            return this.investigationService.getAllInvestigations(offset, amount);
        }
        return this.investigationService.getInvestigationsForInvestigated(target, offset, amount);
    }

    @GuiAction(value="manage-investigations/view/detail")
    public AsyncGui<GuiTemplate> getDetail(@GuiParam(value="investigationId") int investigationId) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("investigation", this.investigationService.getInvestigation(investigationId));
            return GuiTemplate.template("gui/investigations/investigation-detail.ftl", params);
        });
    }

    @GuiAction(value="manage-investigations/pause")
    public void pauseInvestigation(Player player) {
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.investigationService.pauseInvestigation(player));
    }

    @GuiAction(value="manage-investigations/resume")
    public void resumeInvestigation(Player player, @GuiParam(value="investigationId") int investigationId) {
        Investigation investigation = this.investigationService.getInvestigation(investigationId);
        if (investigation.getInvestigatedUuid().isPresent()) {
            SppPlayer investigated = this.playerManager.getOnOrOfflinePlayer(investigation.getInvestigatedUuid().get()).orElseThrow(() -> new BusinessException("Can't resume investigation. Player not found."));
            this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.investigationService.resumeInvestigation(player, investigated));
        } else {
            this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.investigationService.resumeInvestigation(player, investigation.getId()));
        }
    }

    @GuiAction(value="manage-investigations/conclude")
    public void concludeInvestigation(Player player, @GuiParam(value="investigationId") int investigationId) {
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.investigationService.concludeInvestigation(player, investigationId));
    }
}

