/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate.gui.evidence;

import java.util.HashMap;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.CurrentAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionReturnType;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.investigate.Investigation;
import net.shortninja.staffplus.core.domain.staff.investigate.InvestigationEvidenceService;
import net.shortninja.staffplus.core.domain.staff.investigate.InvestigationService;
import net.shortninja.staffplus.core.domain.staff.investigate.gui.evidence.EvidenceDto;
import net.shortninja.staffplus.core.domain.staff.investigate.gui.views.EvidenceOverviewViewBuilder;
import net.shortninja.staffplus.core.domain.staff.investigate.gui.views.InvestigationLinkEvidenceSelectionViewBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class InvestigationEvidenceGuiController {
    private final EvidenceOverviewViewBuilder evidenceOverviewViewBuilder;
    private final InvestigationService investigationService;
    private final InvestigationEvidenceService investigationEvidenceService;
    private final InvestigationLinkEvidenceSelectionViewBuilder investigationLinkEvidenceSelectionViewBuilder;
    private final BukkitUtils bukkitUtils;

    public InvestigationEvidenceGuiController(EvidenceOverviewViewBuilder evidenceOverviewViewBuilder, InvestigationService investigationService, InvestigationEvidenceService investigationEvidenceService, InvestigationLinkEvidenceSelectionViewBuilder investigationLinkEvidenceSelectionViewBuilder, BukkitUtils bukkitUtils) {
        this.evidenceOverviewViewBuilder = evidenceOverviewViewBuilder;
        this.investigationService = investigationService;
        this.investigationEvidenceService = investigationEvidenceService;
        this.investigationLinkEvidenceSelectionViewBuilder = investigationLinkEvidenceSelectionViewBuilder;
        this.bukkitUtils = bukkitUtils;
    }

    @GuiAction(value="manage-investigation-evidence/view")
    public AsyncGui<TubingGui> getEvidenceOverview(Player player, @GuiParam(value="page", defaultValue="0") int page, @GuiParam(value="investigationId") int investigationId, @CurrentAction String currentAction) {
        return AsyncGui.async(() -> {
            Investigation investigation = this.investigationService.getInvestigation(investigationId);
            return this.evidenceOverviewViewBuilder.buildGui(player, investigation, page, currentAction);
        });
    }

    @GuiAction(value="manage-investigation-evidence/view/unlink")
    public GuiTemplate goToUnlinkEvidenceView(@GuiParam(value="evidenceId") int evidenceId, @GuiParam(value="investigationId") int investigationId) {
        String confirmAction = GuiActionBuilder.builder().action("manage-investigation-evidence/unlink").param("evidenceId", String.valueOf(evidenceId)).param("investigationId", String.valueOf(investigationId)).build();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("confirmationMessage", "Are you sure you want to unlink evidence: (ID=" + evidenceId + ")");
        params.put("title", "Unlink evidence?");
        params.put("confirmAction", confirmAction);
        return GuiTemplate.template("gui/commons/confirmation.ftl", params);
    }

    @GuiAction(value="manage-investigation-evidence/unlink")
    public AsyncGui<GuiActionReturnType> unlinkEvidence(Player player, @GuiParam(value="evidenceId") int evidenceId, @GuiParam(value="investigationId") int investigationId) {
        return AsyncGui.async(() -> {
            Investigation investigation = this.investigationService.getInvestigation(investigationId);
            this.investigationEvidenceService.unlinkEvidence(player, investigation, evidenceId);
            return GuiActionReturnType.BACK;
        });
    }

    @GuiAction(value="manage-investigation-evidence/view/investigation-link")
    public AsyncGui<TubingGui> getOverview(@GuiParam(value="page", defaultValue="0") int page, @CurrentAction String currentAction, @GuiParam(value="evidenceId") int evidenceId, @GuiParam(value="evidenceType") String evidenceType, @GuiParam(value="evidenceDescription") String evidenceDescription) {
        return AsyncGui.async(() -> this.investigationLinkEvidenceSelectionViewBuilder.buildGui(page, currentAction, new EvidenceDto(evidenceId, evidenceType, evidenceDescription)));
    }

    @GuiAction(value="manage-investigation-evidence/link")
    public void linkEvidence(Player player, @GuiParam(value="investigationId") int investigationId, @GuiParam(value="evidenceId") int evidenceId, @GuiParam(value="evidenceType") String evidenceType, @GuiParam(value="evidenceDescription") String evidenceDescription) {
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> {
            Investigation investigation = this.investigationService.getInvestigation(investigationId);
            this.investigationEvidenceService.linkEvidence(player, investigation, new EvidenceDto(evidenceId, evidenceType, evidenceDescription));
        });
    }
}

