/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate.gui.evidence;

import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.investigate.config.InvestigationConfiguration;
import net.shortninja.staffplusplus.investigate.IInvestigation;
import net.shortninja.staffplusplus.investigate.InvestigationEvidenceLinkedEvent;
import net.shortninja.staffplusplus.investigate.InvestigationEvidenceUnlinkedEvent;
import net.shortninja.staffplusplus.investigate.evidence.IInvestigationEvidence;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class InvestigationEvidenceChatNotifier
implements Listener {
    private static final String INVESTIGATION_EVIDENCE_LINKED = "Linked evidence %evidenceType% (ID=%evidenceId%) to investigation (ID=%investigationId%)";
    private static final String INVESTIGATION_EVIDENCE_UNLINKED = "Removed evidence %evidenceType% (ID=%evidenceId%) from investigation (ID=%investigationId%)";
    private final PlayerManager playerManager;
    private final Messages messages;
    private final InvestigationConfiguration investigationConfiguration;

    public InvestigationEvidenceChatNotifier(PlayerManager playerManager, Messages messages, InvestigationConfiguration investigationConfiguration) {
        this.playerManager = playerManager;
        this.messages = messages;
        this.investigationConfiguration = investigationConfiguration;
    }

    @EventHandler
    public void notifyEvidenceLinked(InvestigationEvidenceLinkedEvent event) {
        IInvestigation investigation = event.getInvestigation();
        this.sendInvestigatorMessage(investigation, event.getInvestigationEvidence(), INVESTIGATION_EVIDENCE_LINKED);
        this.sendStaffNotifications(investigation, event.getInvestigationEvidence(), this.messages.investigationEvidenceLinked);
    }

    @EventHandler
    public void notifyEvidenceUnlinked(InvestigationEvidenceUnlinkedEvent event) {
        IInvestigation investigation = event.getInvestigation();
        this.sendInvestigatorMessage(investigation, event.getInvestigationEvidence(), INVESTIGATION_EVIDENCE_UNLINKED);
        this.sendStaffNotifications(investigation, event.getInvestigationEvidence(), this.messages.investigationEvidenceUnlinked);
    }

    private void sendStaffNotifications(IInvestigation investigation, IInvestigationEvidence evidence, String messageToSend) {
        if (messageToSend != null) {
            String message = messageToSend.replace("%investigationId%", String.valueOf(investigation.getId())).replace("%investigator%", investigation.getInvestigatorName()).replace("%evidenceId%", String.valueOf(evidence.getEvidenceId())).replace("%evidenceType%", evidence.getEvidenceType()).replace("%investigated%", investigation.getInvestigatedName().orElse("Unknown"));
            this.messages.sendGroupMessage(message, this.investigationConfiguration.getStaffNotificationPermission(), this.messages.prefixInvestigations);
        }
    }

    private void sendInvestigatorMessage(IInvestigation investigation, IInvestigationEvidence evidence, String investigatorMessage) {
        Optional<SppPlayer> investigator = this.playerManager.getOnlinePlayer(investigation.getInvestigatorUuid());
        investigator.map(SppPlayer::getPlayer).ifPresent(p -> {
            String message = investigatorMessage.replace("%investigationId%", String.valueOf(investigation.getId())).replace("%evidenceId%", String.valueOf(evidence.getEvidenceId())).replace("%evidenceType%", evidence.getEvidenceType());
            this.messages.send((CommandSender)p, message, this.messages.prefixInvestigations);
        });
    }
}

