/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate.gui.cmd;

import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.investigate.InvestigationNoteService;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:investigations.manage.add-note", permissions={"permissions:investigations.manage.add-note"}, description="Add a note to your investigation", usage="[note]")
@IocBean(conditionalOnProperty="investigations-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class AddNoteInvestigationCmd
extends AbstractCmd {
    private final InvestigationNoteService investigationNoteService;
    private final BukkitUtils bukkitUtils;

    public AddNoteInvestigationCmd(Messages messages, CommandService commandService, InvestigationNoteService investigationNoteService, PermissionHandler permissionHandler, BukkitUtils bukkitUtils) {
        super(messages, permissionHandler, commandService);
        this.investigationNoteService = investigationNoteService;
        this.bukkitUtils = bukkitUtils;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        if (!(sender instanceof Player)) {
            throw new BusinessException(this.messages.onlyPlayers);
        }
        this.bukkitUtils.runTaskAsync(sender, () -> this.investigationNoteService.addNote((Player)sender, JavaUtils.compileWords(args, 0)));
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 1;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.empty();
    }
}

