/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate.gui;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.StaffPlusPlusJoinedEvent;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.investigate.Investigation;
import net.shortninja.staffplus.core.domain.staff.investigate.bungee.InvestigationBungee;
import net.shortninja.staffplus.core.domain.staff.investigate.bungee.events.InvestigationConcludedBungeeEvent;
import net.shortninja.staffplus.core.domain.staff.investigate.bungee.events.InvestigationPausedBungeeEvent;
import net.shortninja.staffplus.core.domain.staff.investigate.bungee.events.InvestigationStartedBungeeEvent;
import net.shortninja.staffplus.core.domain.staff.investigate.config.InvestigationConfiguration;
import net.shortninja.staffplus.core.domain.staff.investigate.database.investigation.InvestigationsRepository;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.investigate.IInvestigation;
import net.shortninja.staffplusplus.investigate.InvestigationConcludedEvent;
import net.shortninja.staffplusplus.investigate.InvestigationPausedEvent;
import net.shortninja.staffplusplus.investigate.InvestigationStartedEvent;
import net.shortninja.staffplusplus.investigate.InvestigationStatus;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@IocBukkitListener
public class InvestigationChatNotifier
implements Listener {
    private static final String INVESTIGATION_STARTED = "Investigation Started (ID=%investigationId%)";
    private static final String INVESTIGATION_CONCLUDED = "Investigation Concluded (ID=%investigationId%)";
    private static final String INVESTIGATION_PAUSED = "Investigation Paused (ID=%investigationId%)";
    private final PlayerManager playerManager;
    private final Messages messages;
    private final InvestigationConfiguration investigationConfiguration;
    private final InvestigationsRepository investigationsRepository;

    public InvestigationChatNotifier(PlayerManager playerManager, Messages messages, InvestigationConfiguration investigationConfiguration, InvestigationsRepository investigationsRepository) {
        this.playerManager = playerManager;
        this.messages = messages;
        this.investigationConfiguration = investigationConfiguration;
        this.investigationsRepository = investigationsRepository;
    }

    @EventHandler
    public void notifyInvestigationStarted(InvestigationStartedEvent event) {
        IInvestigation investigation = event.getInvestigation();
        this.sendInvestigatorMessage(investigation, INVESTIGATION_STARTED);
        this.sendInvestigatedMessage(investigation, this.messages.investigatedInvestigationStarted);
        this.sendStaffNotifications(investigation, this.messages.investigationStaffNotificationsStarted);
    }

    @EventHandler
    public void notifyInvestigationStarted(InvestigationStartedBungeeEvent event) {
        InvestigationBungee investigation = event.getInvestigation();
        this.sendInvestigatorMessage(investigation, INVESTIGATION_STARTED);
        this.sendInvestigatedMessage(investigation, this.messages.investigatedInvestigationStarted);
        this.sendStaffNotifications(investigation, this.messages.investigationStaffNotificationsStarted);
    }

    @EventHandler
    public void notifyInvestigationConcluded(InvestigationConcludedEvent event) {
        IInvestigation investigation = event.getInvestigation();
        this.sendInvestigatorMessage(investigation, INVESTIGATION_CONCLUDED);
        this.sendInvestigatedMessage(investigation, this.messages.investigatedInvestigationConcluded);
        this.sendStaffNotifications(investigation, this.messages.investigationStaffNotificationsConcluded);
    }

    @EventHandler
    public void notifyInvestigationConcluded(InvestigationConcludedBungeeEvent event) {
        InvestigationBungee investigation = event.getInvestigation();
        this.sendInvestigatorMessage(investigation, INVESTIGATION_CONCLUDED);
        this.sendInvestigatedMessage(investigation, this.messages.investigatedInvestigationConcluded);
        this.sendStaffNotifications(investigation, this.messages.investigationStaffNotificationsConcluded);
    }

    @EventHandler
    public void notifyInvestigationPaused(InvestigationPausedEvent event) {
        IInvestigation investigation = event.getInvestigation();
        this.sendInvestigatorMessage(investigation, INVESTIGATION_PAUSED);
        this.sendInvestigatedMessage(investigation, this.messages.investigatedInvestigationPaused);
        this.sendStaffNotifications(investigation, this.messages.investigationStaffNotificationsPaused);
    }

    @EventHandler
    public void notifyInvestigationPaused(InvestigationPausedBungeeEvent event) {
        InvestigationBungee investigation = event.getInvestigation();
        this.sendInvestigatorMessage(investigation, INVESTIGATION_PAUSED);
        this.sendInvestigatedMessage(investigation, this.messages.investigatedInvestigationPaused);
        this.sendStaffNotifications(investigation, this.messages.investigationStaffNotificationsPaused);
    }

    @EventHandler
    public void notifyUnderInvestigationOnJoin(StaffPlusPlusJoinedEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)StaffPlusPlus.get(), () -> {
            List<Investigation> investigation = this.investigationsRepository.findAllInvestigationForInvestigated(player.getUniqueId(), Collections.singletonList(InvestigationStatus.OPEN));
            if (!investigation.isEmpty() && StringUtils.isNotEmpty(this.messages.underInvestigationJoin)) {
                this.messages.send((CommandSender)player, this.messages.underInvestigationJoin, this.messages.prefixInvestigations);
            }
        });
    }

    private void sendStaffNotifications(IInvestigation investigation, String messageToSend) {
        if (messageToSend != null) {
            String message = messageToSend.replace("%investigationId%", String.valueOf(investigation.getId())).replace("%investigator%", investigation.getInvestigatorName()).replace("%investigated%", investigation.getInvestigatedName().orElse("Unknown"));
            this.messages.sendGroupMessage(message, this.investigationConfiguration.getStaffNotificationPermission(), this.messages.prefixInvestigations);
        }
    }

    private void sendInvestigatorMessage(IInvestigation investigation, String investigatorMessage) {
        Optional<SppPlayer> investigator = this.playerManager.getOnlinePlayer(investigation.getInvestigatorUuid());
        investigator.map(SppPlayer::getPlayer).ifPresent(p -> {
            String message = investigatorMessage.replace("%investigationId%", String.valueOf(investigation.getId()));
            this.messages.send((CommandSender)p, message, this.messages.prefixInvestigations);
        });
    }

    private void sendInvestigatedMessage(IInvestigation investigation, String investigatedMessage) {
        if (StringUtils.isNotEmpty(investigatedMessage) && this.investigationConfiguration.isInvestigatedChatMessageEnabled()) {
            investigation.getInvestigatedUuid().flatMap(this.playerManager::getOnlinePlayer).filter(SppPlayer::isOnline).ifPresent(sppPlayer -> this.messages.send((CommandSender)sppPlayer.getPlayer(), investigatedMessage, this.messages.prefixInvestigations));
        }
    }
}

