/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate.bungee.receive;

import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitMessageListener;
import net.shortninja.staffplus.core.common.bungee.BungeeClient;
import net.shortninja.staffplus.core.domain.staff.investigate.bungee.InvestigationBungee;
import net.shortninja.staffplus.core.domain.staff.investigate.bungee.events.InvestigationConcludedBungeeEvent;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfiguration;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.messaging.PluginMessageListener;

@IocBukkitMessageListener(channel="BungeeCord", conditionalOnProperty="isNotEmpty(server-sync-module.investigation-sync)")
public class InvestigationConcludedBungeeReceiver
implements PluginMessageListener {
    private final BungeeClient bungeeClient;
    private final ServerSyncConfiguration serverSyncConfiguration;

    public InvestigationConcludedBungeeReceiver(BungeeClient bungeeClient, ServerSyncConfiguration serverSyncConfiguration) {
        this.bungeeClient = bungeeClient;
        this.serverSyncConfiguration = serverSyncConfiguration;
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        Optional bungeeMessage = this.bungeeClient.handleReceived(channel, "staffplusplus.investigation-concluded", message, InvestigationBungee.class);
        if (bungeeMessage.isPresent() && this.serverSyncConfiguration.investigationSyncServers.matchesServer(((InvestigationBungee)bungeeMessage.get()).getServerName())) {
            Bukkit.getPluginManager().callEvent((Event)new InvestigationConcludedBungeeEvent((InvestigationBungee)bungeeMessage.get()));
        }
    }
}

