/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate.bungee;

import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.common.bungee.BungeeMessage;
import net.shortninja.staffplusplus.investigate.IInvestigation;
import net.shortninja.staffplusplus.investigate.InvestigationStatus;

public class InvestigationBungee
extends BungeeMessage
implements IInvestigation {
    private int id;
    private Long creationTimestamp;
    private Long conclusionTimestamp;
    private ZonedDateTime creationDate;
    private ZonedDateTime conclusionDate;
    private String investigatorName;
    private UUID investigatorUuid;
    private String investigatedName;
    private UUID investigatedUuid;
    private InvestigationStatus status;

    public InvestigationBungee(IInvestigation investigation) {
        super(investigation.getServerName());
        this.id = investigation.getId();
        this.creationDate = investigation.getCreationDate();
        this.conclusionDate = investigation.getConclusionDate().orElse(null);
        this.creationTimestamp = investigation.getCreationTimestamp();
        this.conclusionTimestamp = investigation.getConclusionTimestamp().orElse(null);
        this.investigatorName = investigation.getInvestigatorName();
        this.investigatorUuid = investigation.getInvestigatorUuid();
        this.investigatedName = investigation.getInvestigatedName().orElse(null);
        this.investigatedUuid = investigation.getInvestigatedUuid().orElse(null);
        this.status = investigation.getStatus();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return this.creationDate;
    }

    @Override
    public Optional<Long> getConclusionTimestamp() {
        return Optional.ofNullable(this.conclusionTimestamp);
    }

    @Override
    public Optional<ZonedDateTime> getConclusionDate() {
        return Optional.ofNullable(this.conclusionDate);
    }

    @Override
    public String getInvestigatorName() {
        return this.investigatorName;
    }

    @Override
    public UUID getInvestigatorUuid() {
        return this.investigatorUuid;
    }

    @Override
    public Optional<String> getInvestigatedName() {
        return Optional.ofNullable(this.investigatedName);
    }

    @Override
    public Optional<UUID> getInvestigatedUuid() {
        return Optional.ofNullable(this.investigatedUuid);
    }

    @Override
    public InvestigationStatus getStatus() {
        return this.status;
    }
}

