/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigObjectList;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.actions.ActionService;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommand;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommandMapper;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.investigate.actions.InvestigationInvestigatedActionFilter;
import net.shortninja.staffplusplus.investigate.IInvestigation;
import net.shortninja.staffplusplus.investigate.InvestigationConcludedEvent;
import net.shortninja.staffplusplus.investigate.InvestigationPausedEvent;
import net.shortninja.staffplusplus.investigate.InvestigationStartedEvent;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class InvestigationActionsHook
implements Listener {
    @ConfigProperty(value="investigations-module.start-investigation-commands")
    @ConfigObjectList(value=ConfiguredCommand.class)
    private List<ConfiguredCommand> startInvestigationCommands = new ArrayList<ConfiguredCommand>();
    @ConfigProperty(value="investigations-module.conclude-investigation-commands")
    @ConfigObjectList(value=ConfiguredCommand.class)
    private List<ConfiguredCommand> concludeInvestigationCommands = new ArrayList<ConfiguredCommand>();
    @ConfigProperty(value="investigations-module.pause-investigation-commands")
    @ConfigObjectList(value=ConfiguredCommand.class)
    private List<ConfiguredCommand> pauseInvestigationCommands = new ArrayList<ConfiguredCommand>();
    private final ActionService actionService;
    private final PlayerManager playerManager;
    private final ConfiguredCommandMapper configuredCommandMapper;
    private final BukkitUtils bukkitUtils;

    public InvestigationActionsHook(ActionService actionService, PlayerManager playerManager, ConfiguredCommandMapper configuredCommandMapper, BukkitUtils bukkitUtils) {
        this.actionService = actionService;
        this.playerManager = playerManager;
        this.configuredCommandMapper = configuredCommandMapper;
        this.bukkitUtils = bukkitUtils;
    }

    @EventHandler
    public void onStart(InvestigationStartedEvent event) {
        this.executeActions(event.getInvestigation(), this.startInvestigationCommands);
    }

    @EventHandler
    public void onConclude(InvestigationConcludedEvent event) {
        this.executeActions(event.getInvestigation(), this.concludeInvestigationCommands);
    }

    @EventHandler
    public void onPause(InvestigationPausedEvent event) {
        this.executeActions(event.getInvestigation(), this.pauseInvestigationCommands);
    }

    private void executeActions(IInvestigation investigation, List<ConfiguredCommand> concludeInvestigationCommands) {
        if (concludeInvestigationCommands.isEmpty()) {
            return;
        }
        Optional<SppPlayer> investigator = this.playerManager.getOnlinePlayer(investigation.getInvestigatorUuid());
        Optional investigated = investigation.getInvestigatedUuid().flatMap(this.playerManager::getOnlinePlayer);
        this.bukkitUtils.runTaskAsync(() -> {
            if (investigator.isPresent()) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                investigator.ifPresent(sppPlayer -> placeholders.put("%investigator%", sppPlayer.getUsername()));
                investigated.ifPresent(sppPlayer -> placeholders.put("%investigated%", sppPlayer.getUsername()));
                HashMap<String, OfflinePlayer> targets = new HashMap<String, OfflinePlayer>();
                investigator.ifPresent(sppPlayer -> targets.put("investigator", sppPlayer.getOfflinePlayer()));
                investigated.ifPresent(sppPlayer -> targets.put("investigated", sppPlayer.getOfflinePlayer()));
                InvestigationInvestigatedActionFilter filter = new InvestigationInvestigatedActionFilter(investigation);
                this.actionService.createCommands(this.configuredCommandMapper.toCreateRequests(concludeInvestigationCommands, placeholders, targets, Collections.singletonList(filter)));
            }
        });
    }
}

