/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate;

import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.investigate.InvestigationService;
import net.shortninja.staffplus.core.domain.staff.investigate.config.InvestigationConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.StaffModeService;
import net.shortninja.staffplusplus.investigate.InvestigationStartedEvent;
import net.shortninja.staffplusplus.staffmode.ExitStaffModeEvent;
import net.shortninja.staffplusplus.staffmode.SwitchStaffModeEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class StaffModeHook
implements Listener {
    private final StaffModeService staffModeService;
    private final PlayerManager playerManager;
    private final InvestigationService investigationService;
    private final BukkitUtils bukkitUtils;
    private final InvestigationConfiguration investigationConfiguration;

    public StaffModeHook(StaffModeService staffModeService, PlayerManager playerManager, InvestigationService investigationService, BukkitUtils bukkitUtils, InvestigationConfiguration investigationConfiguration) {
        this.staffModeService = staffModeService;
        this.playerManager = playerManager;
        this.investigationService = investigationService;
        this.bukkitUtils = bukkitUtils;
        this.investigationConfiguration = investigationConfiguration;
    }

    @EventHandler
    public void handleInvestigationStarted(InvestigationStartedEvent investigationStartedEvent) {
        if (this.investigationConfiguration.isEnforceStaffMode()) {
            this.playerManager.getOnlinePlayer(investigationStartedEvent.getInvestigation().getInvestigatorUuid()).ifPresent(p -> this.bukkitUtils.runTaskAsync(() -> {
                if (this.investigationConfiguration.getStaffMode().isPresent()) {
                    this.staffModeService.turnStaffModeOn(p.getPlayer(), this.investigationConfiguration.getStaffMode().get());
                } else {
                    this.staffModeService.turnStaffModeOn(p.getPlayer());
                }
            }));
        }
    }

    @EventHandler
    public void handleExitStaffMode(ExitStaffModeEvent exitStaffModeEvent) {
        if (this.investigationConfiguration.isEnforceStaffMode()) {
            this.playerManager.getOnlinePlayer(exitStaffModeEvent.getPlayerUuid()).ifPresent(p -> this.investigationService.tryPausingInvestigation(p.getPlayer()));
        }
    }

    @EventHandler
    public void handleExitStaffMode(SwitchStaffModeEvent switchStaffModeEvent) {
        Optional<String> staffModeConfig = this.investigationConfiguration.getStaffMode();
        if (this.investigationConfiguration.isEnforceStaffMode() && staffModeConfig.isPresent() && !staffModeConfig.get().equalsIgnoreCase(switchStaffModeEvent.getToMode())) {
            this.playerManager.getOnlinePlayer(switchStaffModeEvent.getPlayerUuid()).ifPresent(p -> this.investigationService.tryPausingInvestigation(p.getPlayer()));
        }
    }
}

