/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate;

import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.bootstrap.PluginDisable;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.TubingBukkitPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.BeforeTubingReload;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.investigate.InvestigationService;
import net.shortninja.staffplus.core.domain.staff.investigate.database.investigation.InvestigationsRepository;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

@IocBukkitListener
@IocMultiProvider(value={PluginDisable.class, BeforeTubingReload.class})
public class PauseInvestigationOnQuit
implements Listener,
PluginDisable,
BeforeTubingReload {
    private final InvestigationService investigationService;
    private final InvestigationsRepository investigationsRepository;
    private final BukkitUtils bukkitUtils;

    public PauseInvestigationOnQuit(InvestigationService investigationService, InvestigationsRepository investigationsRepository, BukkitUtils bukkitUtils) {
        this.investigationService = investigationService;
        this.investigationsRepository = investigationsRepository;
        this.bukkitUtils = bukkitUtils;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.investigationService.tryPausingInvestigation(player));
    }

    @Override
    public void disable(StaffPlusPlus staffPlusPlus) {
        this.investigationsRepository.pauseAllInvestigations();
    }

    @Override
    public void execute(TubingBukkitPlugin tubingPlugin) {
        this.investigationsRepository.pauseAllInvestigations();
    }
}

