/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.investigate.Investigation;
import net.shortninja.staffplus.core.domain.staff.investigate.config.InvestigationConfiguration;
import net.shortninja.staffplus.core.domain.staff.investigate.database.investigation.InvestigationsRepository;
import net.shortninja.staffplusplus.investigate.IInvestigation;
import net.shortninja.staffplusplus.investigate.InvestigationConcludedEvent;
import net.shortninja.staffplusplus.investigate.InvestigationPausedEvent;
import net.shortninja.staffplusplus.investigate.InvestigationStartedEvent;
import net.shortninja.staffplusplus.investigate.InvestigationStatus;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@IocBean
public class InvestigationService {
    private final InvestigationsRepository investigationsRepository;
    private final Options options;
    private final Messages messages;
    private final PermissionHandler permissionHandler;
    private final InvestigationConfiguration investigationConfiguration;

    public InvestigationService(InvestigationsRepository investigationsRepository, Options options, Messages messages, PermissionHandler permissionHandler, InvestigationConfiguration investigationConfiguration) {
        this.investigationsRepository = investigationsRepository;
        this.options = options;
        this.messages = messages;
        this.permissionHandler = permissionHandler;
        this.investigationConfiguration = investigationConfiguration;
    }

    public void startInvestigation(Player investigator, SppPlayer investigated) {
        this.permissionHandler.validate((CommandSender)investigator, this.investigationConfiguration.getInvestigatePermission());
        this.validateInvestigationStart(investigator, investigated);
        Investigation investigation = new Investigation(investigator.getName(), investigator.getUniqueId(), investigated.getUsername(), investigated.getId(), this.options.serverName);
        int id = this.investigationsRepository.addInvestigation(investigation);
        investigation.setId(id);
        BukkitUtils.sendEvent(new InvestigationStartedEvent(investigation));
    }

    public void startInvestigation(Player investigator) {
        this.permissionHandler.validate((CommandSender)investigator, this.investigationConfiguration.getInvestigatePermission());
        this.validateInvestigationStart(investigator);
        Investigation investigation = new Investigation(investigator.getName(), investigator.getUniqueId(), this.options.serverName);
        int id = this.investigationsRepository.addInvestigation(investigation);
        investigation.setId(id);
        BukkitUtils.sendEvent(new InvestigationStartedEvent(investigation));
    }

    public void resumeInvestigation(Player investigator, int investigationId) {
        this.permissionHandler.validate((CommandSender)investigator, this.investigationConfiguration.getInvestigatePermission());
        this.validateInvestigationStart(investigator);
        Investigation investigation = this.getInvestigation(investigationId);
        if (investigation.getStatus() != InvestigationStatus.PAUSED) {
            throw new BusinessException("&CCan not resume investigation. This investigation is not paused");
        }
        investigation.setStatus(InvestigationStatus.OPEN);
        investigation.setInvestigatorName(investigator.getName());
        investigation.setInvestigatorUuid(investigator.getUniqueId());
        this.investigationsRepository.updateInvestigation(investigation);
        BukkitUtils.sendEvent(new InvestigationStartedEvent(investigation));
    }

    public void resumeInvestigation(Player investigator, SppPlayer investigated) {
        this.permissionHandler.validate((CommandSender)investigator, this.investigationConfiguration.getInvestigatePermission());
        this.validateInvestigationStart(investigator, investigated);
        Investigation investigation = this.investigationsRepository.findInvestigationForInvestigated(investigator.getUniqueId(), investigated.getId(), Collections.singletonList(InvestigationStatus.PAUSED)).orElseThrow(() -> new BusinessException("Cannot resume investigation. No paused investigation found"));
        investigation.setStatus(InvestigationStatus.OPEN);
        investigation.setInvestigatorName(investigator.getName());
        investigation.setInvestigatorUuid(investigator.getUniqueId());
        this.investigationsRepository.updateInvestigation(investigation);
        BukkitUtils.sendEvent(new InvestigationStartedEvent(investigation));
    }

    public Optional<Investigation> getPausedInvestigation(Player investigator, SppPlayer investigated) {
        return this.investigationsRepository.findInvestigationForInvestigated(investigator.getUniqueId(), investigated.getId(), Collections.singletonList(InvestigationStatus.PAUSED));
    }

    public List<Investigation> getPausedInvestigations(Player investigator) {
        return this.investigationsRepository.findAllInvestigationsForInvestigator(investigator.getUniqueId(), Collections.singletonList(InvestigationStatus.PAUSED));
    }

    public List<Investigation> getPausedInvestigations(Player investigator, int offset, int amount) {
        return this.investigationsRepository.findAllInvestigationsForInvestigator(investigator.getUniqueId(), Collections.singletonList(InvestigationStatus.PAUSED), offset, amount);
    }

    public void concludeInvestigation(Player investigator) {
        this.permissionHandler.validate((CommandSender)investigator, this.investigationConfiguration.getInvestigatePermission());
        Investigation investigation = this.investigationsRepository.getInvestigationForInvestigator(investigator.getUniqueId(), Collections.singletonList(InvestigationStatus.OPEN)).orElseThrow(() -> new BusinessException("&CYou currently have no investigation running.", this.messages.prefixInvestigations));
        investigation.setConclusionDate(System.currentTimeMillis());
        investigation.setStatus(InvestigationStatus.CONCLUDED);
        this.investigationsRepository.updateInvestigation(investigation);
        BukkitUtils.sendEvent(new InvestigationConcludedEvent(investigation));
    }

    public void concludeInvestigation(Player investigator, int investigationId) {
        this.permissionHandler.validate((CommandSender)investigator, this.investigationConfiguration.getInvestigatePermission());
        Investigation investigation = this.investigationsRepository.findInvestigation(investigationId).orElseThrow(() -> new BusinessException("&CNo investigation found with thid id.", this.messages.prefixInvestigations));
        if (investigation.getStatus() == InvestigationStatus.OPEN && !investigation.getInvestigatorUuid().equals(investigator.getUniqueId())) {
            throw new BusinessException("$CCannot conclude the investigation. This investigation is currently ongoing.");
        }
        investigation.setConclusionDate(System.currentTimeMillis());
        investigation.setStatus(InvestigationStatus.CONCLUDED);
        this.investigationsRepository.updateInvestigation(investigation);
        BukkitUtils.sendEvent(new InvestigationConcludedEvent(investigation));
    }

    public void pauseInvestigation(Player investigator) {
        Investigation investigation = this.investigationsRepository.getInvestigationForInvestigator(investigator.getUniqueId(), Collections.singletonList(InvestigationStatus.OPEN)).orElseThrow(() -> new BusinessException("&CYou currently have no investigation running", this.messages.prefixInvestigations));
        investigation.setStatus(InvestigationStatus.PAUSED);
        this.investigationsRepository.updateInvestigation(investigation);
        BukkitUtils.sendEvent(new InvestigationPausedEvent(investigation));
    }

    public void tryPausingInvestigation(Player investigator) {
        this.investigationsRepository.getInvestigationForInvestigator(investigator.getUniqueId(), Collections.singletonList(InvestigationStatus.OPEN)).ifPresent(investigation -> {
            investigation.setStatus(InvestigationStatus.PAUSED);
            this.investigationsRepository.updateInvestigation((Investigation)investigation);
            BukkitUtils.sendEvent(new InvestigationPausedEvent((IInvestigation)investigation));
        });
    }

    public void pauseInvestigationsForInvestigated(Player investigated) {
        List<Investigation> investigations = this.investigationsRepository.getInvestigationsForInvestigated(investigated.getUniqueId(), Collections.singletonList(InvestigationStatus.OPEN));
        for (Investigation investigation : investigations) {
            investigation.setStatus(InvestigationStatus.PAUSED);
            this.investigationsRepository.updateInvestigation(investigation);
            BukkitUtils.sendEvent(new InvestigationPausedEvent(investigation));
        }
    }

    public List<Investigation> getAllInvestigations(int offset, int amount) {
        return this.investigationsRepository.getAllInvestigations(offset, amount);
    }

    public List<Investigation> getInvestigationsForInvestigated(SppPlayer sppPlayer, int offset, int amount) {
        return this.investigationsRepository.getInvestigationsForInvestigated(sppPlayer.getId(), offset, amount);
    }

    public Investigation getInvestigation(int investigationId) {
        return this.investigationsRepository.findInvestigation(investigationId).orElseThrow(() -> new BusinessException("Investigation with id [" + investigationId + "] not found", this.messages.prefixInvestigations));
    }

    private void validateInvestigationStart(Player investigator, SppPlayer investigated) {
        if (!investigated.isOnline() && !this.investigationConfiguration.isAllowOfflineInvestigation()) {
            throw new BusinessException("Not allowed to investigate an offline player");
        }
        this.investigationsRepository.getInvestigationForInvestigator(investigator.getUniqueId(), Collections.singletonList(InvestigationStatus.OPEN)).ifPresent(investigation1 -> {
            throw new BusinessException("&CCan't start an investigation, you currently have an investigation running", this.messages.prefixInvestigations);
        });
        List<Investigation> runningInvestigations = this.investigationsRepository.getInvestigationsForInvestigated(investigated.getId(), Collections.singletonList(InvestigationStatus.OPEN));
        if (this.investigationConfiguration.getMaxConcurrentInvestigation() > 0 && runningInvestigations.size() >= this.investigationConfiguration.getMaxConcurrentInvestigation()) {
            throw new BusinessException("&CCannot start investigation. There are already too many investigations ongoing at this moment.");
        }
    }

    private void validateInvestigationStart(Player investigator) {
        this.investigationsRepository.getInvestigationForInvestigator(investigator.getUniqueId(), Collections.singletonList(InvestigationStatus.OPEN)).ifPresent(investigation1 -> {
            throw new BusinessException("&CCan't start an investigation, you currently have an investigation running", this.messages.prefixInvestigations);
        });
    }
}

