/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.investigate.Investigation;
import net.shortninja.staffplus.core.domain.staff.investigate.InvestigationNoteEntity;
import net.shortninja.staffplus.core.domain.staff.investigate.config.InvestigationConfiguration;
import net.shortninja.staffplus.core.domain.staff.investigate.database.investigation.InvestigationsRepository;
import net.shortninja.staffplus.core.domain.staff.investigate.database.notes.InvestigationNotesRepository;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.investigate.InvestigationNoteCreatedEvent;
import net.shortninja.staffplusplus.investigate.InvestigationNoteDeletedEvent;
import net.shortninja.staffplusplus.investigate.InvestigationStatus;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@IocBean
public class InvestigationNoteService {
    private final InvestigationsRepository investigationsRepository;
    private final InvestigationNotesRepository investigationNotesRepository;
    private final PermissionHandler permissionHandler;
    private final Messages messages;
    private final InvestigationConfiguration investigationConfiguration;

    public InvestigationNoteService(InvestigationsRepository investigationsRepository, InvestigationNotesRepository investigationNotesRepository, PermissionHandler permissionHandler, Messages messages, InvestigationConfiguration investigationConfiguration) {
        this.investigationsRepository = investigationsRepository;
        this.investigationNotesRepository = investigationNotesRepository;
        this.permissionHandler = permissionHandler;
        this.messages = messages;
        this.investigationConfiguration = investigationConfiguration;
    }

    public void addNote(Player noteTaker, String note) {
        this.validateNoteCreation(noteTaker, note);
        Investigation investigation = this.investigationsRepository.getInvestigationForInvestigator(noteTaker.getUniqueId(), Collections.singletonList(InvestigationStatus.OPEN)).orElseThrow(() -> new BusinessException("&CYou currently have no investigation running.", this.messages.prefixInvestigations));
        InvestigationNoteEntity investigationNoteEntity = new InvestigationNoteEntity(investigation.getId(), note, noteTaker.getUniqueId(), noteTaker.getName());
        this.investigationNotesRepository.addNote(investigationNoteEntity);
        BukkitUtils.sendEvent(new InvestigationNoteCreatedEvent(investigation, investigationNoteEntity));
    }

    public void addNote(Player noteTaker, Investigation investigation, String note) {
        this.validateNoteCreation(noteTaker, note);
        InvestigationNoteEntity investigationNoteEntity = new InvestigationNoteEntity(investigation.getId(), note, noteTaker.getUniqueId(), noteTaker.getName());
        this.investigationNotesRepository.addNote(investigationNoteEntity);
        BukkitUtils.sendEvent(new InvestigationNoteCreatedEvent(investigation, investigationNoteEntity));
    }

    private void validateNoteCreation(Player noteTaker, String note) {
        this.permissionHandler.validate((CommandSender)noteTaker, this.investigationConfiguration.getAddNotePermission());
        if (StringUtils.isEmpty(note)) {
            throw new BusinessException("Note not cannot be empty");
        }
    }

    public void deleteNote(Player player, Investigation investigation, int id) {
        this.permissionHandler.validate((CommandSender)player, this.investigationConfiguration.getDeleteNotePermission());
        Optional<InvestigationNoteEntity> noteEntity = this.investigationNotesRepository.find(id);
        if (noteEntity.isPresent()) {
            if (!noteEntity.get().getNotedByUuid().equals(player.getUniqueId())) {
                this.permissionHandler.validate((CommandSender)player, this.investigationConfiguration.getDeleteNoteOthersPermission());
            }
            this.investigationNotesRepository.removeNote(id);
            BukkitUtils.sendEvent(new InvestigationNoteDeletedEvent(investigation, noteEntity.get()));
        }
    }

    public List<InvestigationNoteEntity> getNotesForInvestigation(Investigation investigation) {
        return this.investigationNotesRepository.getAllNotes(investigation.getId());
    }

    public List<InvestigationNoteEntity> getNotesForInvestigation(Investigation investigation, int offset, int amount) {
        return this.investigationNotesRepository.getAllNotes(investigation.getId(), offset, amount);
    }
}

