/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.UUID;
import net.shortninja.staffplusplus.investigate.IInvestigationNote;

public class InvestigationNoteEntity
implements IInvestigationNote {
    private int id;
    private final int investigationId;
    private final String note;
    private final UUID notedByUuid;
    private final String notedByName;
    private final long timestamp;

    public InvestigationNoteEntity(int investigationId, String note, UUID notedByUuid, String notedByName) {
        this.investigationId = investigationId;
        this.note = note;
        this.notedByUuid = notedByUuid;
        this.notedByName = notedByName;
        this.timestamp = System.currentTimeMillis();
    }

    public InvestigationNoteEntity(int id, int investigationId, String note, UUID notedByUuid, String notedByName, long timestamp) {
        this.id = id;
        this.investigationId = investigationId;
        this.note = note;
        this.notedByUuid = notedByUuid;
        this.notedByName = notedByName;
        this.timestamp = timestamp;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int getInvestigationId() {
        return this.investigationId;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public UUID getNotedByUuid() {
        return this.notedByUuid;
    }

    @Override
    public Long getCreationTimestamp() {
        return this.timestamp;
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.timestamp), ZoneId.systemDefault());
    }

    @Override
    public String getNotedByName() {
        return this.notedByName;
    }
}

