/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate;

import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.investigate.EvidenceEntity;
import net.shortninja.staffplus.core.domain.staff.investigate.Investigation;
import net.shortninja.staffplus.core.domain.staff.investigate.config.InvestigationConfiguration;
import net.shortninja.staffplus.core.domain.staff.investigate.database.evidence.InvestigationEvidenceRepository;
import net.shortninja.staffplusplus.investigate.InvestigationEvidenceLinkedEvent;
import net.shortninja.staffplusplus.investigate.InvestigationEvidenceUnlinkedEvent;
import net.shortninja.staffplusplus.investigate.evidence.Evidence;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@IocBean
public class InvestigationEvidenceService {
    private final InvestigationEvidenceRepository investigationEvidenceRepository;
    private final PermissionHandler permissionHandler;
    private final InvestigationConfiguration investigationConfiguration;

    public InvestigationEvidenceService(InvestigationEvidenceRepository investigationEvidenceRepository, PermissionHandler permissionHandler, InvestigationConfiguration investigationConfiguration) {
        this.investigationEvidenceRepository = investigationEvidenceRepository;
        this.permissionHandler = permissionHandler;
        this.investigationConfiguration = investigationConfiguration;
    }

    public void linkEvidence(Player linker, Investigation investigation, Evidence evidence) {
        this.permissionHandler.validate((CommandSender)linker, this.investigationConfiguration.getLinkEvidencePermission());
        Optional<EvidenceEntity> linkedEvidence = this.investigationEvidenceRepository.findLinkedEvidence(investigation, evidence);
        if (linkedEvidence.isPresent()) {
            throw new BusinessException("&CCannot link evidence. This evidence piece is already linked to this investigation");
        }
        EvidenceEntity evidenceEntity = new EvidenceEntity(investigation.getId(), evidence.getId(), evidence.getEvidenceType(), linker.getUniqueId(), linker.getName(), evidence.getDescription());
        this.investigationEvidenceRepository.addEvidence(evidenceEntity);
        BukkitUtils.sendEvent(new InvestigationEvidenceLinkedEvent(investigation, evidenceEntity));
    }

    public void unlinkEvidence(Player unlinker, Investigation investigation, int id) {
        this.permissionHandler.validate((CommandSender)unlinker, this.investigationConfiguration.getLinkEvidencePermission());
        Optional<EvidenceEntity> evidenceEntity = this.investigationEvidenceRepository.find(id);
        if (evidenceEntity.isPresent()) {
            this.investigationEvidenceRepository.removeEvidence(id);
            BukkitUtils.sendEvent(new InvestigationEvidenceUnlinkedEvent(investigation, evidenceEntity.get()));
        }
    }

    public List<EvidenceEntity> getEvidenceForInvestigation(Investigation investigation) {
        return this.investigationEvidenceRepository.getAllEvidence(investigation.getId());
    }

    public List<EvidenceEntity> getEvidenceForInvestigation(Investigation investigation, int offset, int amount) {
        return this.investigationEvidenceRepository.getAllEvidence(investigation.getId(), offset, amount);
    }
}

