/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplusplus.investigate.IInvestigation;
import net.shortninja.staffplusplus.investigate.InvestigationStatus;

public class Investigation
implements IInvestigation {
    private int id;
    private Long creationDate;
    private Long conclusionDate;
    private String investigatorName;
    private UUID investigatorUuid;
    private String investigatedName;
    private UUID investigatedUuid;
    private String serverName;
    private InvestigationStatus status;

    public Investigation(int id, Long creationDate, Long conclusionDate, String investigatorName, UUID investigatorUuid, String investigatedName, UUID investigatedUuid, String serverName, InvestigationStatus status) {
        this.id = id;
        this.creationDate = creationDate;
        this.conclusionDate = conclusionDate;
        this.investigatorName = investigatorName;
        this.investigatorUuid = investigatorUuid;
        this.investigatedName = investigatedName;
        this.investigatedUuid = investigatedUuid;
        this.serverName = serverName;
        this.status = status;
    }

    public Investigation(String investigatorName, UUID investigatorUuid, String investigatedName, UUID investigatedUuid, String serverName) {
        this.investigatorName = investigatorName;
        this.investigatorUuid = investigatorUuid;
        this.investigatedName = investigatedName;
        this.investigatedUuid = investigatedUuid;
        this.serverName = serverName;
        this.status = InvestigationStatus.OPEN;
        this.creationDate = System.currentTimeMillis();
    }

    public Investigation(String investigatorName, UUID investigatorUuid, String serverName) {
        this.investigatorName = investigatorName;
        this.investigatorUuid = investigatorUuid;
        this.serverName = serverName;
        this.status = InvestigationStatus.OPEN;
        this.creationDate = System.currentTimeMillis();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Long getCreationTimestamp() {
        return this.creationDate;
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.creationDate), ZoneId.systemDefault());
    }

    @Override
    public Optional<Long> getConclusionTimestamp() {
        return Optional.ofNullable(this.conclusionDate);
    }

    @Override
    public Optional<ZonedDateTime> getConclusionDate() {
        if (this.conclusionDate == null) {
            return Optional.empty();
        }
        return Optional.of(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.conclusionDate), ZoneId.systemDefault()));
    }

    @Override
    public String getInvestigatorName() {
        return this.investigatorName;
    }

    @Override
    public UUID getInvestigatorUuid() {
        return this.investigatorUuid;
    }

    @Override
    public Optional<String> getInvestigatedName() {
        return Optional.ofNullable(this.investigatedName);
    }

    @Override
    public Optional<UUID> getInvestigatedUuid() {
        return Optional.ofNullable(this.investigatedUuid);
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public InvestigationStatus getStatus() {
        return this.status;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setStatus(InvestigationStatus status) {
        this.status = status;
    }

    public void setConclusionDate(Long conclusionDate) {
        this.conclusionDate = conclusionDate;
    }

    public void setInvestigatorName(String investigatorName) {
        this.investigatorName = investigatorName;
    }

    public void setInvestigatorUuid(UUID investigatorUuid) {
        this.investigatorUuid = investigatorUuid;
    }
}

