/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.investigate;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.UUID;
import net.shortninja.staffplusplus.investigate.evidence.Evidence;
import net.shortninja.staffplusplus.investigate.evidence.IInvestigationEvidence;

public class EvidenceEntity
implements IInvestigationEvidence,
Evidence {
    private int id;
    private int investigationId;
    private int evidenceId;
    private String evidenceType;
    private UUID linkedByUuid;
    private String linkedByName;
    private String description;
    private long timestamp;

    public EvidenceEntity(int investigationId, int evidenceId, String evidenceType, UUID linkedByUuid, String linkedByName, String description) {
        this.investigationId = investigationId;
        this.evidenceId = evidenceId;
        this.evidenceType = evidenceType;
        this.linkedByUuid = linkedByUuid;
        this.linkedByName = linkedByName;
        this.description = description;
        this.timestamp = System.currentTimeMillis();
    }

    public EvidenceEntity(int id, int investigationId, int evidenceId, String evidenceType, UUID linkedByUuid, String linkedByName, String description, long timestamp) {
        this.id = id;
        this.investigationId = investigationId;
        this.evidenceId = evidenceId;
        this.evidenceType = evidenceType;
        this.linkedByUuid = linkedByUuid;
        this.linkedByName = linkedByName;
        this.description = description;
        this.timestamp = timestamp;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getInvestigationId() {
        return this.investigationId;
    }

    @Override
    public int getEvidenceId() {
        return this.evidenceId;
    }

    @Override
    public String getEvidenceType() {
        return this.evidenceType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public UUID getLinkedByUuid() {
        return this.linkedByUuid;
    }

    @Override
    public Long getCreationTimestamp() {
        return this.timestamp;
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.timestamp), ZoneId.systemDefault());
    }

    @Override
    public String getLinkedByName() {
        return this.linkedByName;
    }
}

