/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.infractions.gui.views;

import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMulti;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGui;
import net.shortninja.staffplus.core.common.gui.PagedGuiBuilder;
import net.shortninja.staffplus.core.domain.staff.infractions.Infraction;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionsService;
import net.shortninja.staffplus.core.domain.staff.infractions.gui.views.InfractionGuiProvider;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.entity.Player;

@IocBean
public class InfractionsOverviewViewBuilder {
    private static final int PAGE_SIZE = 45;
    private final InfractionsService infractionsService;
    private final List<InfractionGuiProvider> infractionGuiProviders;

    public InfractionsOverviewViewBuilder(InfractionsService infractionsService, @IocMulti(value=InfractionGuiProvider.class) List<InfractionGuiProvider> infractionGuiProviders) {
        this.infractionsService = infractionsService;
        this.infractionGuiProviders = infractionGuiProviders;
    }

    public TubingGui buildGui(Player player, SppPlayer target, int page, String currentAction) {
        return new PagedGuiBuilder.Builder("Infractions " + target.getUsername()).addPagedItems(currentAction, this.getItems(player, target, page), i -> {
            InfractionGuiProvider infractionGuiProvider = this.getInfractionGuiProvider((Infraction)i);
            return infractionGuiProvider.getMenuItem(i);
        }, i -> "$NOOP", page).build();
    }

    public List<Infraction> getItems(Player player, SppPlayer target, int currentPage) {
        return this.infractionsService.getAllInfractions(player, target.getId(), currentPage * 45, 45);
    }

    private InfractionGuiProvider getInfractionGuiProvider(Infraction i) {
        return this.infractionGuiProviders.stream().filter(guiProvider -> guiProvider.getType().equals((Object)i.getInfractionType())).findFirst().orElseThrow(() -> new RuntimeException("No gui provider for infraction type: [" + (Object)((Object)i.getInfractionType()) + "]"));
    }
}

