/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.infractions.gui;

import java.util.Collections;
import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.CurrentAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGui;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionType;
import net.shortninja.staffplus.core.domain.staff.infractions.gui.views.InfractionsOverviewViewBuilder;
import net.shortninja.staffplus.core.domain.staff.infractions.gui.views.InfractionsTopViewBuilder;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.entity.Player;

@GuiController
public class InfractionsGuiController {
    private final InfractionsOverviewViewBuilder infractionsOverviewViewBuilder;
    private final InfractionsTopViewBuilder infractionsTopViewBuilder;
    private final PlayerManager playerManager;

    public InfractionsGuiController(InfractionsOverviewViewBuilder infractionsOverviewViewBuilder, InfractionsTopViewBuilder infractionsTopViewBuilder, PlayerManager playerManager) {
        this.infractionsOverviewViewBuilder = infractionsOverviewViewBuilder;
        this.infractionsTopViewBuilder = infractionsTopViewBuilder;
        this.playerManager = playerManager;
    }

    @GuiAction(value="manage-infractions/view/overview")
    public AsyncGui<TubingGui> getOverview(Player player, @GuiParam(value="targetPlayerName") String targetPlayerName, @GuiParam(value="page", defaultValue="0") int page, @CurrentAction String currentAction) {
        SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        return AsyncGui.async(() -> this.infractionsOverviewViewBuilder.buildGui(player, sppPlayer, page, currentAction));
    }

    @GuiAction(value="manage-infractions/view/top")
    public AsyncGui<TubingGui> getTop(@GuiParam(value="infractionType") String type, @GuiParam(value="page", defaultValue="0") int page, @CurrentAction String currentAction) {
        return AsyncGui.async(() -> {
            List<InfractionType> infractionTypes = StringUtils.isBlank(type) ? Collections.emptyList() : Collections.singletonList(InfractionType.valueOf(type));
            return this.infractionsTopViewBuilder.buildGui(page, infractionTypes, currentAction);
        });
    }
}

