/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.infractions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMulti;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.infractions.Infraction;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionInfo;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionOverview;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionProvider;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionType;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.entity.Player;

@IocBean
public class InfractionsService {
    private final List<InfractionProvider> infractionProviders;
    private final PlayerManager playerManager;

    public InfractionsService(@IocMulti(value=InfractionProvider.class) List<InfractionProvider> infractionProviders, PlayerManager playerManager) {
        this.infractionProviders = infractionProviders;
        this.playerManager = playerManager;
    }

    public List<Infraction> getAllInfractions(Player executor, UUID playerUuid, int page, int pageSize) {
        ArrayList<? extends Infraction> infractions = new ArrayList<Infraction>();
        for (InfractionProvider infractionProvider : this.infractionProviders) {
            infractions.addAll(infractionProvider.getInfractions(executor, playerUuid));
        }
        infractions.sort(Comparator.comparingLong(Infraction::getCreationTimestamp).reversed());
        return JavaUtils.getPageOfList(infractions, page, pageSize);
    }

    public List<InfractionOverview> getTopInfractions(int page, int pageSize, List<InfractionType> infractionFilters) {
        ArrayList<InfractionOverview> infractions = new ArrayList<InfractionOverview>();
        this.infractionProviders.stream().filter(infractionProvider -> infractionFilters.isEmpty() || infractionFilters.contains((Object)infractionProvider.getType())).map(InfractionProvider::getInfractionsInfo).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).forEach(infractionInfo -> this.addInfractionOverview((List<InfractionOverview>)infractions, (InfractionInfo)infractionInfo));
        infractions.sort(Comparator.comparingInt(InfractionOverview::getTotal).reversed());
        return JavaUtils.getPageOfList(infractions, page, pageSize);
    }

    private void addInfractionOverview(List<InfractionOverview> infractions, InfractionInfo infractionInfo) {
        infractionInfo.getCounts().keySet().forEach(uuid -> this.addInfractionOverview(infractions, infractionInfo, (UUID)uuid));
    }

    private void addInfractionOverview(List<InfractionOverview> infractions, InfractionInfo infractionsCount, UUID uuid) {
        Optional<InfractionOverview> existingOverviewItem = infractions.stream().filter(overview -> overview.getSppPlayer().getId().equals(uuid)).findFirst();
        if (!existingOverviewItem.isPresent()) {
            Optional<SppPlayer> onOrOfflinePlayer = this.playerManager.getOnOrOfflinePlayer(uuid);
            if (!onOrOfflinePlayer.isPresent()) {
                return;
            }
            existingOverviewItem = Optional.of(new InfractionOverview());
            existingOverviewItem.get().setSppPlayer(onOrOfflinePlayer.get());
            infractions.add(existingOverviewItem.get());
        }
        existingOverviewItem.get().getInfractions().put(infractionsCount.getInfractionType(), infractionsCount.getCounts().get(uuid));
        if (infractionsCount.getAdditionalInfo().containsKey(uuid)) {
            existingOverviewItem.get().getAdditionalInfo().addAll((Collection<String>)infractionsCount.getAdditionalInfo().get(uuid));
        }
    }
}

