/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.freeze.gui;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.staff.freeze.FreezeGui;
import net.shortninja.staffplus.core.domain.staff.freeze.config.FreezeConfiguration;
import net.shortninja.staffplusplus.freeze.PlayerFrozenEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@IocBukkitListener
public class FreezeListener
implements Listener {
    private final FreezeConfiguration freezeConfiguration;
    private final Messages messages;

    public FreezeListener(FreezeConfiguration freezeConfiguration, Messages messages) {
        this.freezeConfiguration = freezeConfiguration;
        this.messages = messages;
    }

    @EventHandler
    public void onFreeze(PlayerFrozenEvent event) {
        Player player = event.getTarget();
        if (this.freezeConfiguration.prompt) {
            new FreezeGui(this.freezeConfiguration.promptTitle).show(player);
        } else if (this.freezeConfiguration.chatMessageEnabled) {
            this.messages.send((CommandSender)player, this.messages.freeze, this.messages.prefixGeneral);
        }
        if (this.freezeConfiguration.blindness || this.freezeConfiguration.prompt) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, Integer.MAX_VALUE, 128));
        }
        this.messages.send(event.getIssuer(), this.messages.staffFroze.replace("%target%", player.getName()), this.messages.prefixGeneral);
        player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP_BOOST, Integer.MAX_VALUE, 128));
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, 128));
        if (this.freezeConfiguration.sound != null) {
            this.freezeConfiguration.sound.play(player);
        }
    }
}

