/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.freeze.gui;

import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionReturnType;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.freeze.FreezeHandler;
import net.shortninja.staffplus.core.domain.staff.freeze.FreezeRequest;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class FreezeGuiController {
    private final PlayerManager playerManager;
    private final FreezeHandler freezeHandler;
    private final OnlineSessionsManager onlineSessionsManager;

    public FreezeGuiController(PlayerManager playerManager, FreezeHandler freezeHandler, OnlineSessionsManager onlineSessionsManager) {
        this.playerManager = playerManager;
        this.freezeHandler = freezeHandler;
        this.onlineSessionsManager = onlineSessionsManager;
    }

    @GuiAction(value="manage-frozen/freeze")
    public GuiActionReturnType freezePlayer(Player player, @GuiParam(value="targetPlayerName") String targetPlayerName, @GuiParam(value="enable") Boolean enable) {
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        PlayerSession session = this.onlineSessionsManager.get(sppPlayer.getPlayer());
        this.freezeHandler.execute(new FreezeRequest((CommandSender)player, sppPlayer.getPlayer(), enable == null ? !session.isFrozen() : enable));
        return GuiActionReturnType.KEEP_OPEN;
    }
}

