/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.freeze.chatchannels;

import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.chatchannels.ChatChannel;
import net.shortninja.staffplus.core.domain.chatchannels.ChatChannelService;
import net.shortninja.staffplusplus.chatchannels.ChatChannelType;
import net.shortninja.staffplusplus.freeze.PlayerFrozenEvent;
import net.shortninja.staffplusplus.freeze.PlayerUnFrozenEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener(conditionalOnProperty="freeze-module.chatchannels.enabled=true")
public class FreezeChatChannelListener
implements Listener {
    @ConfigProperty(value="%lang%:freeze-chatchannel.prefix")
    public String chatChannelPrefix;
    @ConfigProperty(value="%lang%:freeze-chatchannel.chatline")
    public String chatChannelLine;
    @ConfigProperty(value="%lang%:freeze-chatchannel.openingmessage")
    public String chatChannelOpeningMessage;
    private final ChatChannelService chatChannelService;
    private final BukkitUtils bukkitUtils;

    public FreezeChatChannelListener(ChatChannelService chatChannelService, BukkitUtils bukkitUtils) {
        this.chatChannelService = chatChannelService;
        this.bukkitUtils = bukkitUtils;
    }

    @EventHandler
    public void onPlayerFrozen(PlayerFrozenEvent playerFrozenEvent) {
        this.bukkitUtils.runTaskAsync(() -> {
            HashSet<UUID> members = new HashSet<UUID>();
            CommandSender issuer = playerFrozenEvent.getIssuer();
            Player target = playerFrozenEvent.getTarget();
            members.add(issuer instanceof Player ? ((Player)issuer).getUniqueId() : Constants.CONSOLE_UUID);
            members.add(target.getUniqueId());
            Optional<ChatChannel> channel = this.chatChannelService.findChannel(target.getName(), ChatChannelType.FREEZE);
            if (!channel.isPresent()) {
                this.chatChannelService.create(target.getName(), this.chatChannelPrefix, this.chatChannelLine, this.chatChannelOpeningMessage, members, ChatChannelType.FREEZE);
            }
        });
    }

    @EventHandler
    public void onUnfreeze(PlayerUnFrozenEvent playerUnFrozenEvent) {
        this.bukkitUtils.runTaskAsync(() -> this.chatChannelService.closeChannel(playerUnFrozenEvent.getTarget().getName(), ChatChannelType.FREEZE));
    }
}

