/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.freeze;

import java.util.stream.Stream;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.freeze.FreezeRequest;
import net.shortninja.staffplus.core.domain.staff.freeze.config.FreezeConfiguration;
import net.shortninja.staffplusplus.freeze.PlayerFrozenEvent;
import net.shortninja.staffplusplus.freeze.PlayerUnFrozenEvent;
import net.shortninja.staffplusplus.session.IPlayerSession;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@IocBean
public class FreezeHandler {
    @ConfigProperty(value="permissions:freeze-bypass")
    private String permissionFreezeBypass;
    private final PermissionHandler permission;
    private final Messages messages;

    public FreezeHandler(PermissionHandler permission, Messages messages, OnlineSessionsManager sessionManager, PlayerManager playerManager, FreezeConfiguration freezeConfiguration) {
        this.permission = permission;
        this.messages = messages;
        if (freezeConfiguration.titleMessageEnabled) {
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)StaffPlusPlus.get(), () -> sessionManager.getAll().stream().filter(IPlayerSession::isFrozen).map(s -> playerManager.getOnlinePlayer(s.getUuid())).flatMap(optional -> optional.map(Stream::of).orElseGet(Stream::empty)).map(SppPlayer::getPlayer).forEach(player -> player.sendTitle(messages.colorize(messages.freezeTitle), messages.colorize(messages.freezeSubtitle), 1, 25, 1)), 20L, 20L);
        }
    }

    public void execute(FreezeRequest freezeRequest) {
        if (freezeRequest.isEnableFreeze()) {
            this.validatePermissions(freezeRequest.getPlayer());
            this.addFreeze(freezeRequest.getCommandSender(), freezeRequest.getPlayer());
        } else {
            this.removeFreeze(freezeRequest.getCommandSender(), freezeRequest.getPlayer());
        }
    }

    private void addFreeze(CommandSender sender, Player player) {
        BukkitUtils.sendEvent(new PlayerFrozenEvent(sender, player));
    }

    public void removeFreeze(CommandSender sender, Player player) {
        BukkitUtils.sendEventOnThisTick(new PlayerUnFrozenEvent(sender, player));
    }

    public void validatePermissions(Player target) {
        if (this.permission.has(target, this.permissionFreezeBypass)) {
            throw new BusinessException(this.messages.bypassed, this.messages.prefixGeneral);
        }
    }
}

