/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.freeze;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.cmd.arguments.ArgumentType;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.freeze.FreezeHandler;
import net.shortninja.staffplus.core.domain.staff.freeze.FreezeRequest;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:freeze", permissions={"permissions:freeze"}, description="Freezes or unfreezes the player", usage="[enabled | disabled] [player]", delayable=true, playerRetrievalStrategy=PlayerRetrievalStrategy.ONLINE)
@IocBean(conditionalOnProperty="freeze-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class FreezeCmd
extends AbstractCmd {
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private final PermissionHandler permissionHandler;
    private final FreezeHandler freezeHandler;
    private final PlayerManager playerManager;
    private final OnlineSessionsManager onlineSessionsManager;
    @ConfigProperty(value="permissions:freeze-bypass")
    private String permissionFreezeBypass;

    public FreezeCmd(PermissionHandler permissionHandler, Messages messages, FreezeHandler freezeHandler, CommandService commandService, PlayerManager playerManager, OnlineSessionsManager onlineSessionsManager) {
        super(messages, permissionHandler, commandService);
        this.permissionHandler = permissionHandler;
        this.freezeHandler = freezeHandler;
        this.playerManager = playerManager;
        this.onlineSessionsManager = onlineSessionsManager;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer sppPlayer, Map<String, String> optionalParameters) {
        this.freezeHandler.execute(this.buildFreezeRequest(sender, args, sppPlayer.getPlayer()));
        return true;
    }

    @Override
    protected List<ArgumentType> getPreExecutionSppArguments() {
        return Arrays.asList(ArgumentType.TELEPORT, ArgumentType.STRIP, ArgumentType.HEALTH, ArgumentType.DELAY);
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        if (args[0].equalsIgnoreCase(ENABLED) || args[0].equalsIgnoreCase(DISABLED)) {
            return Optional.ofNullable(args[1]);
        }
        return Optional.of(args[0]);
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        if (args.length > 0 && (args[0].equalsIgnoreCase(ENABLED) || args[0].equalsIgnoreCase(DISABLED))) {
            return 2;
        }
        return 1;
    }

    @Override
    protected boolean canBypass(Player player) {
        return this.permissionHandler.has(player, this.permissionFreezeBypass);
    }

    private FreezeRequest buildFreezeRequest(CommandSender sender, String[] args, Player targetPlayer) {
        boolean freeze;
        PlayerSession session = this.onlineSessionsManager.get(targetPlayer);
        boolean bl = freeze = !session.isFrozen();
        if (args[0].equalsIgnoreCase(ENABLED) || args[0].equalsIgnoreCase(DISABLED)) {
            freeze = args[0].equalsIgnoreCase(ENABLED);
        }
        return new FreezeRequest(sender, targetPlayer, freeze);
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args, String[] sppArgs) throws IllegalArgumentException {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            if (!args[0].equalsIgnoreCase(ENABLED) && !args[0].equalsIgnoreCase(DISABLED)) {
                suggestions.add(ENABLED);
                suggestions.add(DISABLED);
            }
            suggestions.addAll(this.playerManager.getOnlinePlayerNames());
            return suggestions.stream().filter(s -> args[0].isEmpty() || s.contains(args[0])).collect(Collectors.toList());
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase(ENABLED) || args[0].equalsIgnoreCase(DISABLED))) {
            return this.playerManager.getOnlinePlayerNames().stream().filter(s -> args[1].isEmpty() || s.contains(args[1])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

