/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.freeze;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.domain.chat.ChatInterceptor;
import net.shortninja.staffplus.core.domain.staff.freeze.config.FreezeConfiguration;
import net.shortninja.staffplusplus.session.IPlayerSession;
import org.bukkit.command.CommandSender;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@IocBean(conditionalOnProperty="freeze-module.enabled=true")
@IocMultiProvider(value={ChatInterceptor.class})
public class FreezeChatInterceptor
implements ChatInterceptor {
    @ConfigProperty(value="%lang%:freeze-chat-prevented")
    private String chatPrevented;
    private final Messages messages;
    private final OnlineSessionsManager onlineSessionsManager;
    private final FreezeConfiguration freezeConfiguration;

    public FreezeChatInterceptor(Messages messages, OnlineSessionsManager onlineSessionsManager, FreezeConfiguration freezeConfiguration) {
        this.messages = messages;
        this.onlineSessionsManager = onlineSessionsManager;
        this.freezeConfiguration = freezeConfiguration;
    }

    @Override
    public boolean intercept(AsyncPlayerChatEvent event) {
        IPlayerSession session = this.onlineSessionsManager.get(event.getPlayer().getUniqueId());
        if (session.isFrozen() && !this.freezeConfiguration.chat) {
            this.messages.send((CommandSender)event.getPlayer(), this.chatPrevented, this.messages.prefixGeneral);
            return true;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 2;
    }
}

