/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.freeze;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.actions.ActionService;
import net.shortninja.staffplus.core.domain.actions.CreateStoredCommandRequest;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommand;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommandMapper;
import net.shortninja.staffplus.core.domain.staff.freeze.config.FreezeConfiguration;
import net.shortninja.staffplusplus.freeze.PlayerFrozenEvent;
import net.shortninja.staffplusplus.freeze.PlayerUnFrozenEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class FreezeActionHook
implements Listener {
    private final FreezeConfiguration freezeConfiguration;
    private final ActionService actionService;
    private final ConfiguredCommandMapper configuredCommandMapper;
    private final BukkitUtils bukkitUtils;

    public FreezeActionHook(FreezeConfiguration freezeConfiguration, ActionService actionService, ConfiguredCommandMapper configuredCommandMapper, BukkitUtils bukkitUtils) {
        this.freezeConfiguration = freezeConfiguration;
        this.actionService = actionService;
        this.configuredCommandMapper = configuredCommandMapper;
        this.bukkitUtils = bukkitUtils;
    }

    @EventHandler
    public void onFrozen(PlayerFrozenEvent event) {
        this.executeActions(event.getIssuer(), event.getTarget(), this.freezeConfiguration.freezeCommandHooks);
    }

    @EventHandler
    public void onUnfreeze(PlayerUnFrozenEvent event) {
        this.executeActions(event.getIssuer(), event.getTarget(), this.freezeConfiguration.unfreezeCommandHooks);
    }

    private void executeActions(CommandSender issuer, Player target, List<ConfiguredCommand> commands) {
        if (commands.isEmpty()) {
            return;
        }
        this.bukkitUtils.runTaskAsync(() -> {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("%issuer%", issuer.getName());
            placeholders.put("%target%", target.getName());
            List<CreateStoredCommandRequest> commancreateStoredCommandRequests = this.configuredCommandMapper.toCreateRequests(commands, placeholders, Collections.emptyMap(), Collections.emptyList());
            this.actionService.createCommands(commancreateStoredCommandRequests);
        });
    }
}

