/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.examine.items;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.common.Items;
import net.shortninja.staffplus.core.domain.staff.examine.gui.ExamineGuiItemProvider;
import net.shortninja.staffplus.core.domain.staff.mode.config.modeitems.examine.ExamineModeConfiguration;
import net.shortninja.staffplus.core.domain.staff.playernotes.PlayerNote;
import net.shortninja.staffplus.core.domain.staff.playernotes.PlayerNoteService;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@IocBean
@IocMultiProvider(value={ExamineGuiItemProvider.class})
public class NotesExamineGuiProvider
implements ExamineGuiItemProvider {
    private final Messages messages;
    private final ExamineModeConfiguration examineModeConfiguration;
    private final PlayerNoteService playerNoteService;

    public NotesExamineGuiProvider(Messages messages, Options options, PlayerNoteService playerNoteService) {
        this.messages = messages;
        this.examineModeConfiguration = options.staffItemsConfiguration.getExamineModeConfiguration();
        this.playerNoteService = playerNoteService;
    }

    @Override
    public ItemStack getItem(Player staff, SppPlayer player) {
        return this.notesItem(staff, player);
    }

    @Override
    public String getClickAction(Player staff, SppPlayer targetPlayer) {
        return GuiActionBuilder.builder().action("player-notes/create").param("targetPlayerName", targetPlayer.getUsername()).build();
    }

    @Override
    public boolean enabled(Player staff, SppPlayer player) {
        return this.examineModeConfiguration.getModeExamineNotes() >= 0;
    }

    @Override
    public int getSlot() {
        return this.examineModeConfiguration.getModeExamineNotes() - 1;
    }

    private ItemStack notesItem(Player staff, SppPlayer target) {
        List<PlayerNote> allPlayerNotes = this.playerNoteService.getAllPlayerNotes((CommandSender)staff, target.getId(), 0, 10);
        List<String> notes = allPlayerNotes.isEmpty() ? Arrays.asList("&7No notes found") : allPlayerNotes.stream().map(PlayerNote::getNote).collect(Collectors.toList());
        ItemStack item = Items.builder().setMaterial(Material.MAP).setAmount(1).setName(this.messages.examineNotes).setLore(notes).build();
        return item;
    }
}

