/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.examine.items;

import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.Items;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.staff.examine.gui.ExamineGuiItemProvider;
import net.shortninja.staffplus.core.domain.staff.mode.config.modeitems.examine.ExamineModeConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@IocBean
@IocMultiProvider(value={ExamineGuiItemProvider.class})
public class IpExamineGuiProvider
implements ExamineGuiItemProvider {
    @ConfigProperty(value="permissions:ipPerm")
    private String ipHidePerm;
    @ConfigProperty(value="permissions:examine-view-ip")
    private String viewIpPermission;
    private final Messages messages;
    private final ExamineModeConfiguration examineModeConfiguration;
    private final PermissionHandler permissionHandler;

    public IpExamineGuiProvider(Messages messages, Options options, PermissionHandler permissionHandler) {
        this.messages = messages;
        this.permissionHandler = permissionHandler;
        this.examineModeConfiguration = options.staffItemsConfiguration.getExamineModeConfiguration();
    }

    @Override
    public ItemStack getItem(Player player1, SppPlayer player) {
        return this.ipItem(player.getPlayer());
    }

    @Override
    public String getClickAction(Player staff, SppPlayer targetPlayer) {
        return "$NOOP";
    }

    @Override
    public boolean enabled(Player staff, SppPlayer player) {
        return this.examineModeConfiguration.getModeExamineIp() >= 0 && player.isOnline() && this.permissionHandler.has(staff, this.viewIpPermission);
    }

    @Override
    public int getSlot() {
        return this.examineModeConfiguration.getModeExamineIp() - 1;
    }

    private ItemStack ipItem(Player player) {
        String ip = this.permissionHandler.has(player, this.ipHidePerm) ? "127.0.0.1" : player.getAddress().getAddress().getHostAddress().replace("/", "");
        return Items.builder().setMaterial(Material.COMPASS).setAmount(1).setName("&bConnection").addLore(this.messages.examineIp.replace("%ipaddress%", ip)).build();
    }
}

