/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.examine.items;

import java.util.ArrayList;
import java.util.List;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.Items;
import net.shortninja.staffplus.core.domain.staff.examine.gui.ExamineGuiItemProvider;
import net.shortninja.staffplus.core.domain.staff.mode.config.modeitems.examine.ExamineModeConfiguration;
import net.shortninja.staffplus.core.domain.staff.reporting.Report;
import net.shortninja.staffplus.core.domain.staff.reporting.ReportService;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.WarnService;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.Warning;
import net.shortninja.staffplusplus.reports.IReport;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@IocBean
@IocMultiProvider(value={ExamineGuiItemProvider.class})
public class InfractionsExamineGuiProvider
implements ExamineGuiItemProvider {
    private final Messages messages;
    private final ExamineModeConfiguration examineModeConfiguration;
    private final ReportService reportService;
    private final WarnService warnService;

    public InfractionsExamineGuiProvider(Messages messages, Options options, ReportService reportService, WarnService warnService) {
        this.messages = messages;
        this.reportService = reportService;
        this.examineModeConfiguration = options.staffItemsConfiguration.getExamineModeConfiguration();
        this.warnService = warnService;
    }

    @Override
    public ItemStack getItem(Player player1, SppPlayer player) {
        return this.infractionsItem(player);
    }

    @Override
    public String getClickAction(Player staff, SppPlayer targetPlayer) {
        return "$NOOP";
    }

    @Override
    public boolean enabled(Player staff, SppPlayer player) {
        return this.examineModeConfiguration.getModeExamineInfractions() >= 0;
    }

    @Override
    public int getSlot() {
        return this.examineModeConfiguration.getModeExamineInfractions() - 1;
    }

    private ItemStack infractionsItem(SppPlayer player) {
        List<Report> reports = this.reportService.getReported(player.getId(), 0, 40);
        ArrayList<String> lore = new ArrayList<String>();
        IReport latestReport = reports.size() >= 1 ? (IReport)reports.get(reports.size() - 1) : null;
        String latestReason = latestReport == null ? "null" : latestReport.getReason();
        for (String string : this.messages.infractionItem) {
            List<Warning> warnings = this.warnService.getWarnings(player.getId(), false);
            lore.add(string.replace("%warnings%", Integer.toString(warnings.size())).replace("%reports%", Integer.toString(reports.size())).replace("%reason%", latestReason));
        }
        ItemStack item = Items.builder().setMaterial(Material.BOOK).setAmount(1).setName("&bInfractions").setLore(lore).build();
        return item;
    }
}

