/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.examine.items;

import java.util.Arrays;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.common.Items;
import net.shortninja.staffplus.core.domain.staff.examine.gui.ExamineGuiItemProvider;
import net.shortninja.staffplus.core.domain.staff.mode.config.modeitems.examine.ExamineModeConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@IocBean
@IocMultiProvider(value={ExamineGuiItemProvider.class})
public class FreezeExamineGuiProvider
implements ExamineGuiItemProvider {
    private final Messages messages;
    private final ExamineModeConfiguration examineModeConfiguration;
    private final OnlineSessionsManager onlineSessionsManager;

    public FreezeExamineGuiProvider(Messages messages, Options options, OnlineSessionsManager onlineSessionsManager) {
        this.messages = messages;
        this.examineModeConfiguration = options.staffItemsConfiguration.getExamineModeConfiguration();
        this.onlineSessionsManager = onlineSessionsManager;
    }

    @Override
    public ItemStack getItem(Player player1, SppPlayer player) {
        return this.freezeItem(player.getPlayer());
    }

    @Override
    public String getClickAction(Player staff, SppPlayer targetPlayer) {
        return GuiActionBuilder.builder().action("manage-frozen/freeze").param("targetPlayerName", targetPlayer.getUsername()).build();
    }

    @Override
    public boolean enabled(Player staff, SppPlayer player) {
        return this.examineModeConfiguration.getModeExamineFreeze() >= 0 && player.isOnline();
    }

    @Override
    public int getSlot() {
        return this.examineModeConfiguration.getModeExamineFreeze() - 1;
    }

    private ItemStack freezeItem(Player player) {
        PlayerSession session = this.onlineSessionsManager.get(player);
        String frozenStatus = session.isFrozen() ? "" : "not ";
        return Items.builder().setMaterial(Material.BLAZE_ROD).setAmount(1).setName("&bFreeze player").setLore(Arrays.asList(this.messages.examineFreeze, "&7Currently " + frozenStatus + "frozen.")).build();
    }
}

