/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.examine;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.chests.EnderChestService;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:echest_view", description="Used to view a players ender chest", usage="[player]", playerRetrievalStrategy=PlayerRetrievalStrategy.BOTH)
@IocBean(conditionalOnProperty="enderchest-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class EChestView
extends AbstractCmd {
    private final EnderChestService enderChestService;
    private final PlayerManager playerManager;

    public EChestView(Messages messages, EnderChestService enderChestService, CommandService commandService, PlayerManager playerManager, PermissionHandler permissionHandler) {
        super(messages, permissionHandler, commandService);
        this.enderChestService = enderChestService;
        this.playerManager = playerManager;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer target, Map<String, String> optionalParameters) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Command can only be used by players");
            return true;
        }
        Player p = (Player)sender;
        this.enderChestService.openEnderChest(p, target);
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 1;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.of(args[0]);
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        if (args.length == 1) {
            return this.playerManager.getAllPlayerNames().stream().filter(s -> args[0].isEmpty() || s.contains(args[0])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

