/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.chests;

import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionReturnType;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionService;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.common.Items;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.common.gui.IAction;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.InventoryFactory;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.chests.ChestGUI;
import net.shortninja.staffplus.core.domain.staff.chests.ChestGuiType;
import net.shortninja.staffplus.core.domain.staff.examine.config.ExamineConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@GuiController
public class InventoryGuiController {
    private final PlayerManager playerManager;
    private final InventoryFactory inventoryFactory;
    private final PermissionHandler permissionHandler;
    private final GuiActionService guiActionService;
    private final ExamineConfiguration examineConfiguration;

    public InventoryGuiController(PlayerManager playerManager, InventoryFactory inventoryFactory, PermissionHandler permissionHandler, GuiActionService guiActionService, ExamineConfiguration examineConfiguration) {
        this.playerManager = playerManager;
        this.inventoryFactory = inventoryFactory;
        this.permissionHandler = permissionHandler;
        this.guiActionService = guiActionService;
        this.examineConfiguration = examineConfiguration;
    }

    @GuiAction(value="manage-inventory/open")
    public GuiActionReturnType openInventory(final Player staff, @GuiParam(value="targetPlayerName") String targetPlayerName) {
        SppPlayer target = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        ChestGUI chestGUI = target.isOnline() ? new ChestGUI(target, (Inventory)target.getPlayer().getPlayer().getInventory(), 45, ChestGuiType.PLAYER_INVENTORY_EXAMINE, this.permissionHandler.has(staff, this.examineConfiguration.getPermissionExamineInventoryInteraction())) : new ChestGUI(target, this.inventoryFactory.loadInventoryOffline(staff, target), 45, ChestGuiType.PLAYER_INVENTORY_EXAMINE, this.permissionHandler.has(staff, this.examineConfiguration.getPermissionExamineInventoryInteractionOffline()));
        this.fillEmptyPlaces(chestGUI);
        chestGUI.setItem(44, Items.createDoor("Back", "Go back"), new IAction(){

            @Override
            public void click(Player player, ItemStack item, int slot, ClickType clickType) {
                InventoryGuiController.this.guiActionService.executeAction(staff, "$BACK");
            }

            @Override
            public boolean shouldClose(Player player) {
                return false;
            }
        });
        chestGUI.show(staff);
        return GuiActionReturnType.KEEP_OPEN;
    }

    private void fillEmptyPlaces(ChestGUI chestGUI) {
        for (int i = 41; i <= 43; ++i) {
            chestGUI.setItem(i, Items.createRedColoredGlass("Not a player slot", ""), null);
        }
    }
}

