/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.chests;

import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionService;
import net.shortninja.staffplus.core.common.Items;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.gui.IAction;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.InventoryFactory;
import net.shortninja.staffplus.core.domain.staff.chests.ChestGUI;
import net.shortninja.staffplus.core.domain.staff.chests.ChestGuiType;
import net.shortninja.staffplus.core.domain.staff.chests.config.EnderchestsConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@IocBean
public class EnderChestService {
    private final PermissionHandler permissionHandler;
    private final InventoryFactory inventoryFactory;
    private final EnderchestsConfiguration enderchestsConfiguration;
    private final GuiActionService guiActionService;

    public EnderChestService(PermissionHandler permissionHandler, InventoryFactory inventoryFactory, EnderchestsConfiguration enderchestsConfiguration, GuiActionService guiActionService) {
        this.permissionHandler = permissionHandler;
        this.inventoryFactory = inventoryFactory;
        this.enderchestsConfiguration = enderchestsConfiguration;
        this.guiActionService = guiActionService;
    }

    public void openEnderChest(Player staff, SppPlayer target) {
        if (target.isOnline()) {
            if (!this.permissionHandler.has(staff, this.enderchestsConfiguration.permissionViewOnline)) {
                throw new BusinessException("&CYou are not allowed to view the enderchest of an online player");
            }
            ChestGUI chestGUI = new ChestGUI(target, target.getPlayer().getEnderChest(), 36, ChestGuiType.ENDER_CHEST_EXAMINE, this.permissionHandler.has(staff, this.enderchestsConfiguration.permissionInteract));
            this.setBackRow(chestGUI, staff);
            chestGUI.show(staff);
        } else {
            if (!this.permissionHandler.has(staff, this.enderchestsConfiguration.permissionViewOffline)) {
                throw new BusinessException("&CYou are not allowed to view the enderchest of an offline player");
            }
            Inventory offlineEnderchest = this.inventoryFactory.loadEnderchestOffline(staff, target);
            ChestGUI chestGUI = new ChestGUI(target, offlineEnderchest, 36, ChestGuiType.ENDER_CHEST_EXAMINE, this.permissionHandler.has(staff, this.enderchestsConfiguration.permissionInteract));
            this.setBackRow(chestGUI, staff);
            chestGUI.show(staff);
        }
    }

    private void setBackRow(ChestGUI chestGUI, final Player staff) {
        this.fillEmptyPlaces(chestGUI);
        chestGUI.setItem(31, Items.createDoor("Back", "Go back"), new IAction(){

            @Override
            public void click(Player player, ItemStack item, int slot, ClickType clickType) {
                EnderChestService.this.guiActionService.executeAction(staff, "$BACK");
            }

            @Override
            public boolean shouldClose(Player player) {
                return false;
            }
        });
    }

    private void fillEmptyPlaces(ChestGUI chestGUI) {
        int i;
        for (i = 27; i <= 30; ++i) {
            chestGUI.setItem(i, Items.createRedColoredGlass("Not a player slot", ""), null);
        }
        for (i = 32; i <= 35; ++i) {
            chestGUI.setItem(i, Items.createRedColoredGlass("Not a player slot", ""), null);
        }
    }
}

